/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class GroupCoordinatorRecordHelpers {
    private static final short GROUP_METADATA_VALUE_VERSION = 3;

    private GroupCoordinatorRecordHelpers() {
    }

    public static CoordinatorRecord newConsumerGroupMemberSubscriptionRecord(String groupId, ConsumerGroupMember member) {
        ArrayList<String> topicNames = new ArrayList<String>(member.subscribedTopicNames());
        Collections.sort(topicNames);
        return CoordinatorRecord.record((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId(groupId).setMemberId(member.memberId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue().setRackId(member.rackId()).setInstanceId(member.instanceId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setSubscribedTopicNames(topicNames).setSubscribedTopicRegex(member.subscribedTopicRegex()).setServerAssignor(member.serverAssignorName().orElse(null)).setRebalanceTimeoutMs(member.rebalanceTimeoutMs()).setClassicMemberMetadata(member.classicMemberMetadata().orElse(null)), 0));
    }

    public static CoordinatorRecord newConsumerGroupMemberSubscriptionTombstoneRecord(String groupId, String memberId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newConsumerGroupSubscriptionMetadataTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newConsumerGroupEpochRecord(String groupId, int newGroupEpoch, long metadataHash) {
        return CoordinatorRecord.record((ApiMessage)new ConsumerGroupMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(newGroupEpoch).setMetadataHash(metadataHash), 0));
    }

    public static CoordinatorRecord newConsumerGroupEpochTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
        ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition> topicPartitions = new ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition>(partitions.size());
        for (Map.Entry<Uuid, Set<Integer>> entry : partitions.entrySet()) {
            topicPartitions.add(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(entry.getKey()).setPartitions(new ArrayList<Integer>((Collection)entry.getValue())));
        }
        return CoordinatorRecord.record((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberValue().setTopicPartitions(topicPartitions), 0));
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentTombstoneRecord(String groupId, String memberId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
        return CoordinatorRecord.record((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataValue().setAssignmentEpoch(assignmentEpoch), 0));
    }

    public static CoordinatorRecord newConsumerGroupTargetAssignmentEpochTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newConsumerGroupCurrentAssignmentRecord(String groupId, ConsumerGroupMember member) {
        return CoordinatorRecord.record((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setState(member.state().value()).setAssignedPartitions(GroupCoordinatorRecordHelpers.toTopicPartitions(member.assignedPartitions())).setPartitionsPendingRevocation(GroupCoordinatorRecordHelpers.toTopicPartitions(member.partitionsPendingRevocation())), 0));
    }

    public static CoordinatorRecord newConsumerGroupCurrentAssignmentTombstoneRecord(String groupId, String memberId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newConsumerGroupRegularExpressionRecord(String groupId, String regex, ResolvedRegularExpression resolvedRegularExpression) {
        ArrayList<String> topics = new ArrayList<String>(resolvedRegularExpression.topics());
        Collections.sort(topics);
        return CoordinatorRecord.record((ApiMessage)new ConsumerGroupRegularExpressionKey().setGroupId(groupId).setRegularExpression(regex), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupRegularExpressionValue().setTopics(topics).setVersion(resolvedRegularExpression.version()).setTimestamp(resolvedRegularExpression.timestamp()), 0));
    }

    public static CoordinatorRecord newConsumerGroupRegularExpressionTombstone(String groupId, String regex) {
        return CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupRegularExpressionKey().setGroupId(groupId).setRegularExpression(regex));
    }

    public static CoordinatorRecord newGroupMetadataRecord(ClassicGroup group, Map<String, byte[]> assignment) {
        ArrayList<GroupMetadataValue.MemberMetadata> members = new ArrayList<GroupMetadataValue.MemberMetadata>(group.allMembers().size());
        group.allMembers().forEach(member -> {
            byte[] subscription = group.protocolName().map(member::metadata).orElse(null);
            if (subscription == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol.");
            }
            byte[] memberAssignment = (byte[])assignment.get(member.memberId());
            if (memberAssignment == null) {
                throw new IllegalStateException("Attempted to write member " + member.memberId() + " of group " + group.groupId() + " with no assignment.");
            }
            members.add(new GroupMetadataValue.MemberMetadata().setMemberId(member.memberId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setRebalanceTimeout(member.rebalanceTimeoutMs()).setSessionTimeout(member.sessionTimeoutMs()).setGroupInstanceId(member.groupInstanceId().orElse(null)).setSubscription(subscription).setAssignment(memberAssignment));
        });
        return CoordinatorRecord.record((ApiMessage)new GroupMetadataKey().setGroup(group.groupId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(group.protocolName().orElse(null)).setProtocolType(group.protocolType().orElse("")).setGeneration(group.generationId()).setLeader(group.leaderOrNull()).setCurrentStateTimestamp(group.currentStateTimestampOrDefault()).setMembers(members), 3));
    }

    public static CoordinatorRecord newGroupMetadataTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new GroupMetadataKey().setGroup(groupId));
    }

    public static CoordinatorRecord newEmptyGroupMetadataRecord(ClassicGroup group) {
        return CoordinatorRecord.record((ApiMessage)new GroupMetadataKey().setGroup(group.groupId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(null).setProtocolType("").setGeneration(0).setLeader(null).setCurrentStateTimestamp(group.currentStateTimestampOrDefault()).setMembers(List.of()), 3));
    }

    public static CoordinatorRecord newOffsetCommitRecord(String groupId, String topic, int partitionId, OffsetAndMetadata offsetAndMetadata) {
        short version = GroupCoordinatorRecordHelpers.offsetCommitValueVersion(offsetAndMetadata.expireTimestampMs.isPresent());
        return CoordinatorRecord.record((ApiMessage)new OffsetCommitKey().setGroup(groupId).setTopic(topic).setPartition(partitionId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new OffsetCommitValue().setOffset(offsetAndMetadata.committedOffset).setLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setMetadata(offsetAndMetadata.metadata).setCommitTimestamp(offsetAndMetadata.commitTimestampMs).setExpireTimestamp(offsetAndMetadata.expireTimestampMs.orElse(-1L)).setTopicId(offsetAndMetadata.topicId), version));
    }

    static short offsetCommitValueVersion(boolean expireTimestampMs) {
        if (expireTimestampMs) {
            return 1;
        }
        return 4;
    }

    public static CoordinatorRecord newOffsetCommitTombstoneRecord(String groupId, String topic, int partitionId) {
        return CoordinatorRecord.tombstone((ApiMessage)new OffsetCommitKey().setGroup(groupId).setTopic(topic).setPartition(partitionId));
    }

    public static CoordinatorRecord newShareGroupMemberSubscriptionRecord(String groupId, ShareGroupMember member) {
        ArrayList<String> topicNames = new ArrayList<String>(member.subscribedTopicNames());
        Collections.sort(topicNames);
        return CoordinatorRecord.record((ApiMessage)new ShareGroupMemberMetadataKey().setGroupId(groupId).setMemberId(member.memberId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ShareGroupMemberMetadataValue().setRackId(member.rackId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setSubscribedTopicNames(topicNames), 0));
    }

    public static CoordinatorRecord newShareGroupMemberSubscriptionTombstoneRecord(String groupId, String memberId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ShareGroupMemberMetadataKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newShareGroupEpochRecord(String groupId, int newGroupEpoch, long metadataHash) {
        return CoordinatorRecord.record((ApiMessage)new ShareGroupMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ShareGroupMetadataValue().setEpoch(newGroupEpoch).setMetadataHash(metadataHash), 0));
    }

    public static CoordinatorRecord newShareGroupEpochTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ShareGroupMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
        ArrayList<ShareGroupTargetAssignmentMemberValue.TopicPartition> topicPartitions = new ArrayList<ShareGroupTargetAssignmentMemberValue.TopicPartition>(partitions.size());
        for (Map.Entry<Uuid, Set<Integer>> entry : partitions.entrySet()) {
            topicPartitions.add(new ShareGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(entry.getKey()).setPartitions(new ArrayList<Integer>((Collection)entry.getValue())));
        }
        return CoordinatorRecord.record((ApiMessage)new ShareGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMemberValue().setTopicPartitions(topicPartitions), 0));
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentTombstoneRecord(String groupId, String memberId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ShareGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
        return CoordinatorRecord.record((ApiMessage)new ShareGroupTargetAssignmentMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ShareGroupTargetAssignmentMetadataValue().setAssignmentEpoch(assignmentEpoch), 0));
    }

    public static CoordinatorRecord newShareGroupTargetAssignmentEpochTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ShareGroupTargetAssignmentMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newShareGroupCurrentAssignmentRecord(String groupId, ShareGroupMember member) {
        return CoordinatorRecord.record((ApiMessage)new ShareGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ShareGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setState(member.state().value()).setAssignedPartitions(GroupCoordinatorRecordHelpers.toShareGroupTopicPartitions(member.assignedPartitions())), 0));
    }

    public static CoordinatorRecord newShareGroupCurrentAssignmentTombstoneRecord(String groupId, String memberId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ShareGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newShareGroupStatePartitionMetadataTombstoneRecord(String groupId) {
        return CoordinatorRecord.tombstone((ApiMessage)new ShareGroupStatePartitionMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newShareGroupStatePartitionMetadataRecord(String groupId, Map<Uuid, ShareGroup.InitMapValue> initializingTopics, Map<Uuid, ShareGroup.InitMapValue> initializedTopics, Map<Uuid, String> deletingTopics) {
        List<ShareGroupStatePartitionMetadataValue.TopicPartitionsInfo> initializingTopicPartitionInfo = initializingTopics.entrySet().stream().map(entry -> new ShareGroupStatePartitionMetadataValue.TopicPartitionsInfo().setTopicId((Uuid)entry.getKey()).setTopicName(((ShareGroup.InitMapValue)entry.getValue()).name()).setPartitions(((ShareGroup.InitMapValue)entry.getValue()).partitions().stream().toList())).toList();
        List<ShareGroupStatePartitionMetadataValue.TopicPartitionsInfo> initializedTopicPartitionInfo = initializedTopics.entrySet().stream().map(entry -> new ShareGroupStatePartitionMetadataValue.TopicPartitionsInfo().setTopicId((Uuid)entry.getKey()).setTopicName(((ShareGroup.InitMapValue)entry.getValue()).name()).setPartitions(((ShareGroup.InitMapValue)entry.getValue()).partitions().stream().toList())).toList();
        List<ShareGroupStatePartitionMetadataValue.TopicInfo> deletingTopicsInfo = deletingTopics.entrySet().stream().map(entry -> new ShareGroupStatePartitionMetadataValue.TopicInfo().setTopicId((Uuid)entry.getKey()).setTopicName((String)entry.getValue())).toList();
        return CoordinatorRecord.record((ApiMessage)new ShareGroupStatePartitionMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ShareGroupStatePartitionMetadataValue().setInitializingTopics(initializingTopicPartitionInfo).setInitializedTopics(initializedTopicPartitionInfo).setDeletingTopics(deletingTopicsInfo), 0));
    }

    private static List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> toTopicPartitions(Map<Uuid, Set<Integer>> topicPartitions) {
        ArrayList<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> topics = new ArrayList<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions>(topicPartitions.size());
        topicPartitions.forEach((topicId, partitions) -> topics.add(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>((Collection<Integer>)partitions))));
        return topics;
    }

    private static List<ShareGroupCurrentMemberAssignmentValue.TopicPartitions> toShareGroupTopicPartitions(Map<Uuid, Set<Integer>> topicPartitions) {
        ArrayList<ShareGroupCurrentMemberAssignmentValue.TopicPartitions> topics = new ArrayList<ShareGroupCurrentMemberAssignmentValue.TopicPartitions>(topicPartitions.size());
        topicPartitions.forEach((topicId, partitions) -> topics.add(new ShareGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>((Collection<Integer>)partitions))));
        return topics;
    }
}

