/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.ConfigPropertyFilter;
import org.apache.kafka.connect.mirror.DefaultConfigPropertyFilter;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.TopicFilter;

public class MirrorSourceConfig
extends MirrorConnectorConfig {
    protected static final String REFRESH_TOPICS = "refresh.topics";
    protected static final String SYNC_TOPIC_CONFIGS = "sync.topic.configs";
    protected static final String SYNC_TOPIC_ACLS = "sync.topic.acls";
    public static final String REPLICATION_FACTOR = "replication.factor";
    private static final String REPLICATION_FACTOR_DOC = "Replication factor for newly created remote topics.";
    public static final int REPLICATION_FACTOR_DEFAULT = 2;
    public static final String TOPICS = "topics";
    public static final String TOPICS_DEFAULT = ".*";
    private static final String TOPICS_DOC = "Topics to replicate. Supports comma-separated topic names and regexes.";
    public static final String TOPICS_EXCLUDE = "topics.exclude";
    public static final String TOPICS_EXCLUDE_DEFAULT = "mm2.*\\.internal, .*\\.replica, __.*";
    private static final String TOPICS_EXCLUDE_DOC = "Excluded topics. Supports comma-separated topic names and regexes. Excludes take precedence over includes.";
    public static final String CONFIG_PROPERTIES_EXCLUDE = "config.properties.exclude";
    public static final String CONFIG_PROPERTIES_EXCLUDE_DEFAULT = "follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas";
    private static final String CONFIG_PROPERTIES_EXCLUDE_DOC = "Topic config properties that should not be replicated. Supports comma-separated property names and regexes.";
    public static final String OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR = "offset-syncs.topic.replication.factor";
    public static final String OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for offset-syncs topic.";
    public static final short OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    static final String TASK_TOPIC_PARTITIONS = "task.assigned.partitions";
    public static final String CONSUMER_POLL_TIMEOUT_MILLIS = "consumer.poll.timeout.ms";
    private static final String CONSUMER_POLL_TIMEOUT_MILLIS_DOC = "Timeout when polling source cluster.";
    public static final long CONSUMER_POLL_TIMEOUT_MILLIS_DEFAULT = 1000L;
    public static final String REFRESH_TOPICS_ENABLED = "refresh.topics.enabled";
    private static final String REFRESH_TOPICS_ENABLED_DOC = "Whether to periodically check for new topics and partitions.";
    public static final boolean REFRESH_TOPICS_ENABLED_DEFAULT = true;
    public static final String REFRESH_TOPICS_INTERVAL_SECONDS = "refresh.topics.interval.seconds";
    private static final String REFRESH_TOPICS_INTERVAL_SECONDS_DOC = "Frequency of topic refresh.";
    public static final long REFRESH_TOPICS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String SYNC_TOPIC_CONFIGS_ENABLED = "sync.topic.configs.enabled";
    private static final String SYNC_TOPIC_CONFIGS_ENABLED_DOC = "Whether to periodically configure remote topics to match their corresponding upstream topics.";
    public static final boolean SYNC_TOPIC_CONFIGS_ENABLED_DEFAULT = true;
    public static final String SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS = "sync.topic.configs.interval.seconds";
    private static final String SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS_DOC = "Frequency of topic config sync.";
    public static final long SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String SYNC_TOPIC_ACLS_ENABLED = "sync.topic.acls.enabled";
    private static final String SYNC_TOPIC_ACLS_ENABLED_DOC = "Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.";
    public static final boolean SYNC_TOPIC_ACLS_ENABLED_DEFAULT = true;
    public static final String SYNC_TOPIC_ACLS_INTERVAL_SECONDS = "sync.topic.acls.interval.seconds";
    private static final String SYNC_TOPIC_ACLS_INTERVAL_SECONDS_DOC = "Frequency of topic ACL sync.";
    public static final long SYNC_TOPIC_ACLS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String CONFIG_PROPERTY_FILTER_CLASS = "config.property.filter.class";
    private static final String CONFIG_PROPERTY_FILTER_CLASS_DOC = "ConfigPropertyFilter to use. Selects topic config  properties to replicate.";
    public static final Class<?> CONFIG_PROPERTY_FILTER_CLASS_DEFAULT = DefaultConfigPropertyFilter.class;
    public static final String OFFSET_LAG_MAX = "offset.lag.max";
    private static final String OFFSET_LAG_MAX_DOC = "How out-of-sync a remote partition can be before it is resynced.";
    public static final long OFFSET_LAG_MAX_DEFAULT = 100L;
    public static final String HEARTBEATS_REPLICATION_ENABLED = "heartbeats.replication.enabled";
    private static final String HEARTBEATS_REPLICATION_ENABLED_DOC = "Whether to replicate the heartbeats topics even when the topic filter does not include them. If set to true, heartbeats topics identified by the replication policy will always be replicated, regardless of the topic filter configuration. If set to false, heartbeats topics will only be replicated if the topic filter allows.";
    public static final boolean HEARTBEATS_REPLICATION_ENABLED_DEFAULT = true;
    public static final String OFFSET_SYNCS_SOURCE_PRODUCER_ROLE = "offset-syncs-source-producer";
    public static final String OFFSET_SYNCS_TARGET_PRODUCER_ROLE = "offset-syncs-target-producer";
    public static final String OFFSET_SYNCS_SOURCE_ADMIN_ROLE = "offset-syncs-source-admin";
    public static final String OFFSET_SYNCS_TARGET_ADMIN_ROLE = "offset-syncs-target-admin";
    protected static final ConfigDef CONNECTOR_CONFIG_DEF = MirrorSourceConfig.defineSourceConfig(new ConfigDef(BASE_CONNECTOR_CONFIG_DEF));

    public MirrorSourceConfig(Map<String, String> props) {
        super(CONNECTOR_CONFIG_DEF, props);
    }

    public MirrorSourceConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
    }

    Map<String, String> taskConfigForTopicPartitions(List<TopicPartition> topicPartitions, int taskIndex) {
        Map props = this.originalsStrings();
        String topicPartitionsString = topicPartitions.stream().map(MirrorUtils::encodeTopicPartition).collect(Collectors.joining(","));
        props.put(TASK_TOPIC_PARTITIONS, topicPartitionsString);
        props.put("task.index", String.valueOf(taskIndex));
        return props;
    }

    String offsetSyncsTopic() {
        String otherClusterAlias = "source".equals(this.offsetSyncsTopicLocation()) ? this.targetClusterAlias() : this.sourceClusterAlias();
        return this.replicationPolicy().offsetSyncsTopic(otherClusterAlias);
    }

    String offsetSyncsTopicLocation() {
        return this.getString("offset-syncs.topic.location");
    }

    Map<String, Object> offsetSyncsTopicAdminConfig() {
        return "source".equals(this.offsetSyncsTopicLocation()) ? this.sourceAdminConfig(OFFSET_SYNCS_SOURCE_ADMIN_ROLE) : this.targetAdminConfig(OFFSET_SYNCS_TARGET_ADMIN_ROLE);
    }

    Map<String, Object> offsetSyncsTopicProducerConfig() {
        return "source".equals(this.offsetSyncsTopicLocation()) ? this.sourceProducerConfig(OFFSET_SYNCS_SOURCE_PRODUCER_ROLE) : this.targetProducerConfig(OFFSET_SYNCS_TARGET_PRODUCER_ROLE);
    }

    String checkpointsTopic() {
        return this.replicationPolicy().checkpointsTopic(this.sourceClusterAlias());
    }

    long maxOffsetLag() {
        return this.getLong(OFFSET_LAG_MAX);
    }

    Duration refreshTopicsInterval() {
        if (this.getBoolean(REFRESH_TOPICS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(REFRESH_TOPICS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration syncTopicConfigsInterval() {
        if (this.getBoolean(SYNC_TOPIC_CONFIGS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration syncTopicAclsInterval() {
        if (this.getBoolean(SYNC_TOPIC_ACLS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(SYNC_TOPIC_ACLS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    int replicationFactor() {
        return this.getInt(REPLICATION_FACTOR);
    }

    short offsetSyncsTopicReplicationFactor() {
        return this.getShort(OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR);
    }

    TopicFilter topicFilter() {
        return (TopicFilter)this.getConfiguredInstance("topic.filter.class", TopicFilter.class);
    }

    ConfigPropertyFilter configPropertyFilter() {
        return (ConfigPropertyFilter)this.getConfiguredInstance(CONFIG_PROPERTY_FILTER_CLASS, ConfigPropertyFilter.class);
    }

    Duration consumerPollTimeout() {
        return Duration.ofMillis(this.getLong(CONSUMER_POLL_TIMEOUT_MILLIS));
    }

    boolean emitOffsetSyncsEnabled() {
        return this.getBoolean("emit.offset-syncs.enabled");
    }

    boolean heartbeatsReplicationEnabled() {
        return this.getBoolean(HEARTBEATS_REPLICATION_ENABLED);
    }

    private static ConfigDef defineSourceConfig(ConfigDef baseConfig) {
        return baseConfig.define(TOPICS, ConfigDef.Type.LIST, (Object)TOPICS_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.HIGH, TOPICS_DOC).define(TOPICS_EXCLUDE, ConfigDef.Type.LIST, (Object)TOPICS_EXCLUDE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.HIGH, TOPICS_EXCLUDE_DOC).define(CONFIG_PROPERTIES_EXCLUDE, ConfigDef.Type.LIST, (Object)CONFIG_PROPERTIES_EXCLUDE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.HIGH, CONFIG_PROPERTIES_EXCLUDE_DOC).define("topic.filter.class", ConfigDef.Type.CLASS, (Object)TOPIC_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, "TopicFilter to use. Selects topics to replicate.").define(CONFIG_PROPERTY_FILTER_CLASS, ConfigDef.Type.CLASS, CONFIG_PROPERTY_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, CONFIG_PROPERTY_FILTER_CLASS_DOC).define(CONSUMER_POLL_TIMEOUT_MILLIS, ConfigDef.Type.LONG, (Object)1000L, ConfigDef.Importance.LOW, CONSUMER_POLL_TIMEOUT_MILLIS_DOC).define(REFRESH_TOPICS_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, REFRESH_TOPICS_ENABLED_DOC).define(REFRESH_TOPICS_INTERVAL_SECONDS, ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, REFRESH_TOPICS_INTERVAL_SECONDS_DOC).define(SYNC_TOPIC_CONFIGS_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, SYNC_TOPIC_CONFIGS_ENABLED_DOC).define(SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS, ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS_DOC).define(SYNC_TOPIC_ACLS_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, SYNC_TOPIC_ACLS_ENABLED_DOC).define(SYNC_TOPIC_ACLS_INTERVAL_SECONDS, ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, SYNC_TOPIC_ACLS_INTERVAL_SECONDS_DOC).define(REPLICATION_FACTOR, ConfigDef.Type.INT, (Object)2, ConfigDef.Importance.LOW, REPLICATION_FACTOR_DOC).define(OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR, ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR_DOC).define(OFFSET_LAG_MAX, ConfigDef.Type.LONG, (Object)100L, ConfigDef.Importance.LOW, OFFSET_LAG_MAX_DOC).define("offset-syncs.topic.location", ConfigDef.Type.STRING, (Object)"source", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"source", "target"}), ConfigDef.Importance.LOW, "The location (source/target) of the offset-syncs topic.").define("emit.offset-syncs.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to store the new offset of the replicated records in offset-syncs topic or not. MirrorCheckpointConnector will not be able to sync group offsets or emit checkpoints if emit.checkpoints.enabled and/or sync.group.offsets.enabled are enabled while emit.offset-syncs.enabled is disabled.").define(HEARTBEATS_REPLICATION_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, HEARTBEATS_REPLICATION_ENABLED_DOC);
    }

    public static void main(String[] args) {
        System.out.println(MirrorSourceConfig.defineSourceConfig(new ConfigDef()).toHtml(4, config -> "mirror_source_" + config));
    }
}

