/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;

public class YAMLElementGenerator {
    private final Project myProject;

    public YAMLElementGenerator(Project project) {
        this.myProject = project;
    }

    public static YAMLElementGenerator getInstance(Project project) {
        return (YAMLElementGenerator)project.getService(YAMLElementGenerator.class);
    }

    @NotNull
    public static String createChainedKey(@NotNull List<String> keyComponents, int indentAddition) {
        if (keyComponents == null) {
            YAMLElementGenerator.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyComponents.size(); ++i) {
            if (i > 0) {
                sb.append(StringUtil.repeatSymbol((char)' ', (int)(indentAddition + 2 * i)));
            }
            sb.append(keyComponents.get(i)).append(":");
            if (i + 1 >= keyComponents.size()) continue;
            sb.append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            YAMLElementGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    public YAMLKeyValue createYamlKeyValueWithSequence(@NotNull String keyName, @NotNull Map<String, String> elementsMap) {
        if (keyName == null) {
            YAMLElementGenerator.$$$reportNull$$$0(2);
        }
        if (elementsMap == null) {
            YAMLElementGenerator.$$$reportNull$$$0(3);
        }
        String yamlString = elementsMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> "%s: %s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
        return this.createYamlKeyValue(keyName, yamlString);
    }

    @NotNull
    public YAMLKeyValue createYamlKeyValue(@NotNull String keyName, @NotNull String valueText) {
        YAMLFile tempValueFile;
        Collection values;
        if (keyName == null) {
            YAMLElementGenerator.$$$reportNull$$$0(4);
        }
        if (valueText == null) {
            YAMLElementGenerator.$$$reportNull$$$0(5);
        }
        String text = (values = PsiTreeUtil.collectElementsOfType((PsiElement)(tempValueFile = this.createDummyYamlWithText(valueText)), (Class[])new Class[]{YAMLValue.class})).isEmpty() ? keyName + ":" : (values.iterator().next() instanceof YAMLScalar && !valueText.contains("\n") ? keyName + ": " + valueText : keyName + ":\n" + YAMLTextUtil.indentText(valueText, 2));
        YAMLFile tempFile = this.createDummyYamlWithText(text);
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLKeyValue.class}).iterator().next();
        if (yAMLKeyValue == null) {
            YAMLElementGenerator.$$$reportNull$$$0(6);
        }
        return yAMLKeyValue;
    }

    @NotNull
    public YAMLQuotedTextImpl createYamlDoubleQuotedString() {
        YAMLFile tempFile = this.createDummyYamlWithText("\"foo\"");
        YAMLQuotedTextImpl yAMLQuotedTextImpl = (YAMLQuotedTextImpl)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLQuotedTextImpl.class}).iterator().next();
        if (yAMLQuotedTextImpl == null) {
            YAMLElementGenerator.$$$reportNull$$$0(7);
        }
        return yAMLQuotedTextImpl;
    }

    @NotNull
    public YAMLFile createDummyYamlWithText(@NotNull String text) {
        if (text == null) {
            YAMLElementGenerator.$$$reportNull$$$0(8);
        }
        YAMLFile yAMLFile = (YAMLFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)text, LocalTimeCounter.currentTime(), false);
        if (yAMLFile == null) {
            YAMLElementGenerator.$$$reportNull$$$0(9);
        }
        return yAMLFile;
    }

    @NotNull
    public PsiElement createEol() {
        YAMLFile file = this.createDummyYamlWithText("\n");
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createSpace() {
        YAMLKeyValue keyValue = this.createYamlKeyValue("foo", "bar");
        ASTNode whitespaceNode = keyValue.getNode().findChildByType(TokenType.WHITE_SPACE);
        assert (whitespaceNode != null);
        PsiElement psiElement = whitespaceNode.getPsi();
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createIndent(int size) {
        YAMLFile file = this.createDummyYamlWithText(StringUtil.repeatSymbol((char)' ', (int)size));
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createColon() {
        YAMLFile file = this.createDummyYamlWithText("? foo : bar");
        PsiElement at = file.findElementAt("? foo ".length());
        assert (at != null && at.getNode().getElementType() == YAMLTokenTypes.COLON);
        PsiElement psiElement = at;
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createComma() {
        YAMLFile file = this.createDummyYamlWithText("[1,2]");
        PsiElement comma = file.findElementAt("[1".length());
        assert (comma != null && comma.getNode().getElementType() == YAMLTokenTypes.COMMA);
        PsiElement psiElement = comma;
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createDocumentMarker() {
        YAMLFile file = this.createDummyYamlWithText("---");
        PsiElement at = file.findElementAt(0);
        assert (at != null && at.getNode().getElementType() == YAMLTokenTypes.DOCUMENT_MARKER);
        PsiElement psiElement = at;
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @NotNull
    public YAMLSequence createEmptySequence() {
        YAMLSequence sequence = (YAMLSequence)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("- dummy"), YAMLSequence.class);
        assert (sequence != null);
        sequence.deleteChildRange(sequence.getFirstChild(), sequence.getLastChild());
        YAMLSequence yAMLSequence = sequence;
        if (yAMLSequence == null) {
            YAMLElementGenerator.$$$reportNull$$$0(16);
        }
        return yAMLSequence;
    }

    @NotNull
    public YAMLSequence createEmptyArray() {
        YAMLSequence sequence = (YAMLSequence)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("[]"), YAMLSequence.class);
        assert (sequence != null);
        YAMLSequence yAMLSequence = sequence;
        if (yAMLSequence == null) {
            YAMLElementGenerator.$$$reportNull$$$0(17);
        }
        return yAMLSequence;
    }

    @NotNull
    public YAMLSequenceItem createEmptySequenceItem() {
        YAMLSequenceItem sequenceItem = (YAMLSequenceItem)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("- dummy"), YAMLSequenceItem.class);
        assert (sequenceItem != null);
        YAMLValue value = sequenceItem.getValue();
        assert (value != null);
        value.deleteChildRange(value.getFirstChild(), value.getLastChild());
        YAMLSequenceItem yAMLSequenceItem = sequenceItem;
        if (yAMLSequenceItem == null) {
            YAMLElementGenerator.$$$reportNull$$$0(18);
        }
        return yAMLSequenceItem;
    }

    @NotNull
    public YAMLSequenceItem createSequenceItem(String text) {
        YAMLSequenceItem sequenceItem = (YAMLSequenceItem)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("- " + text), YAMLSequenceItem.class);
        assert (sequenceItem != null);
        YAMLValue value = sequenceItem.getValue();
        assert (value != null);
        YAMLSequenceItem yAMLSequenceItem = sequenceItem;
        if (yAMLSequenceItem == null) {
            YAMLElementGenerator.$$$reportNull$$$0(19);
        }
        return yAMLSequenceItem;
    }

    @NotNull
    public YAMLSequenceItem createArrayItem(String text) {
        YAMLSequenceItem sequenceItem = (YAMLSequenceItem)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("[" + text + "]"), YAMLSequenceItem.class);
        assert (sequenceItem != null);
        YAMLValue value = sequenceItem.getValue();
        assert (value != null);
        YAMLSequenceItem yAMLSequenceItem = sequenceItem;
        if (yAMLSequenceItem == null) {
            YAMLElementGenerator.$$$reportNull$$$0(20);
        }
        return yAMLSequenceItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyComponents";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLElementGenerator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLElementGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createChainedKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createYamlKeyValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createYamlDoubleQuotedString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyYamlWithText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEol";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createColon";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentMarker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySequence";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyArray";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySequenceItem";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequenceItem";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createChainedKey";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createYamlKeyValueWithSequence";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createYamlKeyValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDummyYamlWithText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

