/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlPsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class XmlIncludeHandler {
    public static boolean isXInclude(PsiElement element) {
        return XmlPsiUtil.isXInclude((PsiElement)element);
    }

    @Nullable
    public static XmlFile resolveXIncludeFile(XmlTag xincludeTag) {
        XmlAttribute hrefAttribute = xincludeTag.getAttribute("href", null);
        if (hrefAttribute == null) {
            return null;
        }
        XmlAttributeValue xmlAttributeValue = hrefAttribute.getValueElement();
        if (xmlAttributeValue == null) {
            return null;
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(Arrays.asList(xmlAttributeValue.getReferences()));
        if (!references.isEmpty()) {
            references.sort((reference1, reference2) -> reference2.getRangeInElement().getStartOffset() - reference1.getRangeInElement().getStartOffset());
            PsiElement target = ((PsiReference)references.get(0)).resolve();
            if (target instanceof XmlFile) {
                return (XmlFile)target;
            }
        }
        return null;
    }
}

