/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui.settings;

import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.model.TerminalTypeAheadSettings;
import java.awt.Font;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface UserSettingsProvider {
    public ColorPalette getTerminalColorPalette();

    public Font getTerminalFont();

    public float getTerminalFontSize();

    default public float getLineSpacing() {
        return 1.0f;
    }

    default public boolean shouldDisableLineSpacingForAlternateScreenBuffer() {
        return false;
    }

    default public boolean shouldFillCharacterBackgroundIncludingLineSpacing() {
        return true;
    }

    @NotNull
    default public TerminalColor getDefaultForeground() {
        return Objects.requireNonNull(this.getDefaultStyle().getForeground());
    }

    @NotNull
    default public TerminalColor getDefaultBackground() {
        return Objects.requireNonNull(this.getDefaultStyle().getBackground());
    }

    @Deprecated
    @NotNull
    default public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.BLACK, TerminalColor.WHITE);
    }

    @NotNull
    public TextStyle getSelectionColor();

    @NotNull
    public TextStyle getFoundPatternColor();

    public TextStyle getHyperlinkColor();

    public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode();

    default public boolean enableTextBlinking() {
        return false;
    }

    default public int slowTextBlinkMs() {
        return 1000;
    }

    default public int rapidTextBlinkMs() {
        return 500;
    }

    public boolean useInverseSelectionColor();

    public boolean copyOnSelect();

    public boolean pasteOnMiddleMouseClick();

    public boolean emulateX11CopyPaste();

    public boolean useAntialiasing();

    public int maxRefreshRate();

    public boolean audibleBell();

    public boolean enableMouseReporting();

    public int caretBlinkingMs();

    public boolean scrollToBottomOnTyping();

    public boolean DECCompatibilityMode();

    public boolean forceActionOnMouseReporting();

    public int getBufferMaxLinesCount();

    public boolean altSendsEscape();

    public boolean ambiguousCharsAreDoubleWidth();

    @NotNull
    public TerminalTypeAheadSettings getTypeAheadSettings();

    default public boolean simulateMouseScrollWithArrowKeysInAlternativeScreen() {
        return this.sendArrowKeysInAlternativeMode();
    }

    @Deprecated(forRemoval=true)
    default public boolean sendArrowKeysInAlternativeMode() {
        return true;
    }

    default public boolean shiftEnterSendsEscCR() {
        return false;
    }
}

