!===============================================================================
! Copyright (C) 2003 Intel Corporation
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!  Content:
!    vsRngCauchy  Example Program Text
!*******************************************************************************

      include 'mkl_vsl.f90'
      include "errcheck.inc"

      program MKL_VSL_TEST

      USE MKL_VSL_TYPE
      USE MKL_VSL

      integer(kind=4) i,nn
      integer n
      integer(kind=4) errcode

      real(kind=4) a,beta
      real(kind=4) r(1000)
      integer brng,method,seed

      TYPE (VSL_STREAM_STATE) :: stream

      EXTERNAL :: CheckVslError

      n=1000
      nn=10

      brng=VSL_BRNG_R250
      method=VSL_RNG_METHOD_CAUCHY_ICDF
      seed=777

      a=2.0
      beta=1.5

!     ***** Initialize *****
      errcode=vslnewstream( stream, brng,  seed )
      call CheckVslError(errcode)

!     ***** Call RNG *****
      errcode=vsrngcauchy( method, stream, n, r, a, beta)
      call CheckVslError(errcode)

!     ***** Printing results *****
      print *,"Sample of vsRngCauchy."
      print *,"----------------------"
      print *,""
      print *,"Parameters:"
      print 11,"    a=",a
      print 11,"    beta=",beta

      print *,""
      print *,"Results (first 10 of 1000):"
      print *,"---------------------------"
      do i=1,nn
        print 10,r(i)
      end do

!     ***** Deinitialize *****
      errcode=vsldeletestream( stream )
      call CheckVslError(errcode)

10    format(F7.3)
11    format(A,F5.3)
12    format(A,F5.2,A,F5.2,A,F5.2,A,F5.2,A)

      end
