/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#pragma OPENCL EXTENSION cl_khr_fp16 : enable

// FmaH 0Gr:0h/0Gr:0h/0Gw:0h 53760000 0 1
__kernel void FmaH(__global half *pA, __global half *pB, __global half *pC)
{
    const int id = get_global_id(0);

    half a = pA[id];
    half b = pB[id];
    half c = 1.f;
    half d = 1.f;
    half e = 1.f;
    half f = 1.f;
    half g = 1.f;
    half h = 1.f;
    half i = 1.f;
    half j = 1.f;
    half k = 1.f;
    half l = 1.f;
    half m = 1.f;
    half n = 1.f;
    half o = 1.f;
    half p = 1.f;
    half q = 1.f;
    half r = 1.f;
    half s = 1.f;
    half t = 1.f;
    half u = 1.f;
    half v = 1.f;
    half w = 1.f;
    half x = 1.f;
    half y = 1.f;
    half z = 1.f;

    for (int count = 0; count < 640; count++)
    {
        c = mad(a, c, c);
        d = mad(b, d, d);
        e = mad(a, e, e);
        f = mad(b, f, f);
        g = mad(a, g, g);
        h = mad(b, h, h);
        i = mad(a, i, i);
        j = mad(b, j, j);
        k = mad(a, k, k);
        l = mad(b, l, l);
        m = mad(a, m, m);
        n = mad(b, n, n);
        o = mad(a, o, o);
        p = mad(b, p, p);
    }
    pC[id] = c + e + g + i + k + m + o + d + f + h + j + l + n + p + q + r + s + t + u + v + w + x + y + z;
}
