<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:exsl="http://exslt.org/common"
                xmlns:str="http://exslt.org/strings"
                xmlns:fnc="urn:functions"
                syntax="norules">
<xsl:import href="config://include/gpu_common_functions.inc"/>
<xsl:output indent="yes" method="xml"/>
<xsl:template match="/">
<bag>
  <xsl:variable name="gpuPrefix" select="exsl:ctx('gpuDisplayMetricPrefix', 'GPU')"/>
  <xsl:variable name="groupingByGpuAdapter">
    <xsl:choose>
    <xsl:when test="fnc:is_multi_gpu_adapter_system() and not(fnc:is_multi_gpu_tile_system())">
      <rowBy>
        <queryRef>/GPUAdapterAlias</queryRef>
        <sort>
          <queryRef>/GPUAdapterAlias</queryRef>
        </sort>
      </rowBy>
    </xsl:when>
    <xsl:when test="fnc:is_multi_gpu_adapter_system() and fnc:is_multi_gpu_tile_system()">
      <rowBy>
        <queryRef>/GPUAdapterAlias/GPUTileName</queryRef>
        <sort>
          <queryRef>/GPUAdapterAlias/GPUTileName</queryRef>
        </sort>
      </rowBy>
    </xsl:when>
    <xsl:when test="not(fnc:is_multi_gpu_adapter_system()) and fnc:is_multi_gpu_tile_system()">
      <rowBy>
        <queryRef>/GPUTileName</queryRef>
        <sort>
          <queryRef>/GPUTileName</queryRef>
        </sort>
      </rowBy>
    </xsl:when>
    </xsl:choose>
  </xsl:variable>
  <timeline>
    <area>
      <rowSet displayName="%GPUUsageOverTime">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer type="InstanceCountOverTime">
          <drawBy>
            <queryRef>/GPUUsageAggregated</queryRef>
          </drawBy>
        </layer>
        <layer type="InstanceCountOverTime">
          <drawBy>
            <queryRef>/GPUSchedUsageAggregated</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUGpuBusyBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </timeline>
  <timelineNoPackets>
    <area>
      <rowSet displayName="%GPUUsageOverTime">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUGpuBusyBase</queryRef>
            <displayAttributes>
              <timelineFormat>area</timelineFormat>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </timelineNoPackets>
  <gpuEnginesNoPackets>
    <xsl:variable name="uncoreEventList" select="exsl:get_row_values_list('dd_uncore_event_type', 'name', ',')"/>
    <area>
      <rowSet displayName="%GPUEngineActivity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%GPUEnginesOverTime">
          <drawBy>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_RENDER_ENGINE_BUSY')">
              <queryRef>/GPURenderEngineBusyBase</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_COMPUTE_ENGINE_BUSY')">
              <queryRef>/GPUComputeEngineBusyBase</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_COPY_ENGINE_BUSY')">
              <queryRef>/GPUCopyEngineBusyBase</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_VIDEO_DECODE_ENGINE0_BUSY')">
              <queryRef>/GPUCommandParserVideoDecodeEngine0Busy</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_VIDEO_DECODE_ENGINE1_BUSY')">
              <queryRef>/GPUCommandParserVideoDecodeEngine1Busy</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE0_BUSY')">
              <queryRef>/GPUCommandParserVideoEnhancementEngine0Busy</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE1_BUSY')">
              <queryRef>/GPUCommandParserVideoEnhancementEngine1Busy</queryRef>
            </xsl:if>
            <xsl:if test="contains($uncoreEventList, 'COMMAND_PARSER_GRAPHICS_SECURITY_CONTROLLER_BUSY')">
              <queryRef>/GPUCommandParserGraphicsSecurityControllerBusy</queryRef>
            </xsl:if>
            <displayAttributes>
              <timelineFormat>area</timelineFormat>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUCommandParserFlushBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </gpuEnginesNoPackets>
  <copyEngine>
    <area>
      <rowSet displayName="%GPUCopyEngine">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUCopyEngineStallBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUCopyEngineReadsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUCopyEngineWritesBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </copyEngine>
  <gpuCoreFrequency>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUCoreFrequency">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUCoreFrequency</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUMediaFrequency">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUMediaFrequency</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </gpuCoreFrequency>
  <graphicsTimelineCommonBasic>
    <area boolean:maxLabels="false">
      <rowSet displayName="%{$gpuPrefix}EUActivity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%{$gpuPrefix}EUArrays" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUEUIdleBase</queryRef>
            <queryRef>/GPUEUActiveBase</queryRef>
            <queryRef>/GPUEUStalledBase</queryRef>
            <displayAttributes>
              <timelineFormat>area</timelineFormat>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineCommonBasic>
  <graphicsTimelineCommonBasicExt>
    <area boolean:maxLabels="false">
      <rowSet displayName="%{$gpuPrefix}EUActivity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%{$gpuPrefix}EUArrays" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPU_EU_IDLE_Base</queryRef>
            <queryRef>/GPU_EU_ACTIVE_Base</queryRef>
            <queryRef>/GPU_EU_STALLED_Base</queryRef>
              <displayAttributes>
              <timelineFormat>area</timelineFormat>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineCommonBasicExt>
  <cpugpuInteractionTimeline>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUCSActivity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUCSThreadIssuedBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuThreadOccupancyBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPU_EU_THREAD_OCCUPANCY_Base</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUGPGPUDispatchBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </cpugpuInteractionTimeline>
  <xsl:variable name="pipelineActiveMetricsAvailable">
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION')">true</xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="str:split(exsl:ctx('gpuAdapterNameList', ''), ';')">
            <xsl:variable name="currentGPUInfo" select="str:split(., '|')"/>
              <xsl:variable name="currentGPUBDF" select="concat('_', str:replace(str:replace(string($currentGPUInfo[1]), '.', '_'), ':', '_'), '_')" />
            <xsl:if test="exsl:is_value_exist('dd_uncore_event_type', 'name', concat('XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION', $currentGPUBDF))">true</xsl:if>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
  <graphicsTimelineCommon>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPU3DPipe">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplesKilledInPsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplesWrittenBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplesBlendedBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUPixelShader">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUPsEuActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUPsEuStallBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUVertexShader">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUVsEuActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUVsEuStallBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%{$gpuPrefix}EUPipelines">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUEuAvgIpcRateBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuFpuBothActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuFpuEmActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuFpuSysActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuMultipleActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuSendActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSendActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuControlActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuFpuActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUFpuActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuEmActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuSysActiveBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSysActiveBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%{$gpuPrefix}EUInstructions">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUSendInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUControlInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuFpuInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuEmInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUEuSysInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUBitconvInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUBarrierInstructionsBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUMathInstructionsBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUXEEUStallMetrics">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUStallInstfetchBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallBarrierBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallAluwrBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallSendwrBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallPipeBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallSbidBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallControlBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUStallOtherBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%{$gpuPrefix}MemoryAccessCoalescence">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUTypedReadCoalRatioBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUTypedWriteCoalRatioBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUUntypedReadCoalRatioBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUUntypedWriteCoalRatioBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true" boolean:maxLabels="false">
      <rowSet displayName="%GTIL3TotalBandwidth">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GTIL3TotalBandwidthForTimeline</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineCommon>
  <graphicsTimelineBWs>
        <area boolean:showYScale="true">
      <rowSet displayName="%GPUMemAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUMemoryReadGB</queryRef>
            <queryRef>/GPUMemoryWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUMemoryActiveBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUStackToStackAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUStackToStackReceiveGB</queryRef>
            <queryRef>/GPUStackToStackTransmitGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUHostToGpuAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUHostToGpuMemoryReadGB</queryRef>
            <queryRef>/GPUHostToGpuMemoryWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUSysMemAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUSysMemReadGB</queryRef>
            <queryRef>/GPUSysMemWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineBWs>
  <graphicsTimelineOverview>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUSamplerActivity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplerBusyBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplerBottleneckBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplerInputBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplerOutputBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplerL1Miss</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUTLBMiss">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%GPUTLBMiss" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUTLBMiss</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUL3ThroughputAndMisses">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUL3ShaderThroughputGB</queryRef>
            <queryRef>/GPUL3SamplerThroughputGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUL3ShaderReadThroughputGB</queryRef>
            <queryRef>/GPUL3ShaderWriteThroughputGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUL3Miss</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUL3InputBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUL3OutputBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUL3BusyBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUL3StallBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUL3SQFullBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUICacheThroughputAndMisses">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUICacheL3ReadGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUICacheMiss</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUICacheL3Miss</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineOverview>
  <graphicsTimelineComputeBasic>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUUntypedMemoryAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUUntypedMemoryReadGB</queryRef>
            <queryRef>/GPUUntypedMemoryWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUTypedMemoryAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUTypedMemoryReadGB</queryRef>
            <queryRef>/GPUTypedMemoryWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUSharedLocalMemoryAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUSharedLocalMemoryReadGB</queryRef>
            <queryRef>/GPUSharedLocalMemoryWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSLMBankConflictBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPULSCAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPULSCReadGB</queryRef>
            <queryRef>/GPULSCWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPULSCMiss</queryRef>
          </drawBy>
        </layer>
          <layer>
            <drawBy>
              <queryRef>/GPULSCInputBase</queryRef>
            </drawBy>
          </layer>
          <layer>
            <drawBy>
              <queryRef>/GPULSCOutputBase</queryRef>
            </drawBy>
          </layer>
        <layer>
          <drawBy>
            <queryRef>/GPULSCPartialWritesBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPULSCL3Access">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPULSCL3ReadGB</queryRef>
            <queryRef>/GPULSCL3WriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPULSCL3Miss</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUDataportAccess">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUDataportReadGB</queryRef>
            <queryRef>/GPUDataportWriteGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:showYScale="true">
      <rowSet displayName="%GPUSamplerL3Access">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer displayName="%AverageBandwidthGB" boolean:allowToHideSeries="true">
          <drawBy>
            <queryRef>/GPUSamplerL3ReadGB</queryRef>
            <displayAttributes>
              <timeScalems>1000</timeScalems>
              <minimumResolutionms>0</minimumResolutionms>
              <timelineFormat>area</timelineFormat>
              <timelinePenWidth>1</timelinePenWidth>
            </displayAttributes>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUSamplerL3Miss</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineComputeBasic>
  <graphicsTimelineComputeExtended>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUShaderBarriersAndAtomics">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUShaderBarriersBase</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUShaderAtomicsBase</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineComputeExtended>
  <graphicsTimelineMedia>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUMediaActivity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUMediaReadRequests</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUMediaWriteRequests</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUVideoDecodeBox0Activity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoDecodeBox0ReadRequests</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoDecodeBox0WriteRequests</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUVideoDecodeBox1Activity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoDecodeBox1ReadRequests</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoDecodeBox1WriteRequests</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUVideoEnhancementBox0Activity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoEnhancementBox0ReadRequests</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoEnhancementBox0WriteRequests</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area boolean:maxLabels="false">
      <rowSet displayName="%GPUVideoEnhancementBox1Activity">
        <xsl:copy-of select="$groupingByGpuAdapter"/>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoEnhancementBox1ReadRequests</queryRef>
          </drawBy>
        </layer>
        <layer>
          <drawBy>
            <queryRef>/GPUVideoEnhancementBox1WriteRequests</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineMedia>
  <graphicsTimelineBottom>
    <area id="computing_queue" rowOutlineStyle="dotted">
      <rowSet displayName="%ComputingQueue">
        <rowBy>
          <queryRef>/ComputingQueue</queryRef>
        </rowBy>
        <columnBy>
          <queryRef>/GPUComputeTaskTimeGPUName</queryRef>
          <queryRef>/ComputeQueueTime</queryRef>
          <queryRef>/FPGAComputeTaskTime</queryRef>
        </columnBy>
        <queryMode>allRows</queryMode>
        <layer type="RowInterval" boolean:showColoringAsLegendItems="true" boolean:showText="true">
          <drawBy>
            <queryRef>/GPUComputeTask</queryRef>
          </drawBy>
          <highlightBy int:groupId="2">
            <queryRef>/GPUComputeTask</queryRef>
          </highlightBy>
          <tooltipBy>
            <queryRef>/GPUComputeTask</queryRef>
            <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
            <queryRef>/GPUComputeSubmitThread</queryRef>
            <queryRef>/GPUComputeGlobalDim</queryRef>
            <queryRef>/GPUComputeLocalDim</queryRef>
            <queryRef>/GPUComputeSimdWidth</queryRef>
          </tooltipBy>
          <hatchBy>
            <queryRef>/GPUComputeTask</queryRef>
          </hatchBy>
          <colorBy>
            <queryRef>/GPUComputeTask</queryRef>
          </colorBy>
        </layer>
        <layer type="RowInterval" boolean:showColoringAsLegendItems="true" boolean:showText="true">
          <drawBy>
            <queryRef>/FPGAComputeTask</queryRef>
          </drawBy>
          <tooltipBy>
            <queryRef>/FPGAComputeTask</queryRef>
          </tooltipBy>
          <hatchBy>
            <queryRef>/FPGAComputeTask</queryRef>
          </hatchBy>
          <colorBy>
            <queryRef>/FPGAComputeTask</queryRef>
          </colorBy>
        </layer>
        <layer type="RowIntervalNested" boolean:showColoringAsLegendItems="false">
          <drawBy>
            <queryRef>/ComputeQueue</queryRef>
          </drawBy>
          <highlightBy int:groupId="2">
            <queryRef>/ComputeQueue</queryRef>
          </highlightBy>
          <tooltipBy>
            <queryRef>/ComputeQueueTaskName</queryRef>
            <queryRef>/ComputeQueuePurpose</queryRef>
            <queryRef>/ComputeQueueSubmitThread</queryRef>
            <queryRef>/GPUComputeGlobalDimQueue</queryRef>
            <queryRef>/GPUComputeLocalDimQueue</queryRef>
            <queryRef>/GPUComputeSimdWidthQueue</queryRef>
          </tooltipBy>
          <colorBy>
            <queryRef>/ComputeQueue</queryRef>
          </colorBy>
          <hatchBy>
            <queryRef>/ComputeQueue</queryRef>
          </hatchBy>
        </layer>
      </rowSet>
    </area>
    <area id="draw_call_queue">
      <rowSet displayName="%ParallelExecution">
        <rowBy>
          <queryRef>/GPUNode</queryRef>
        </rowBy>
        <columnBy>
          <queryRef>/DrawCallTime</queryRef>
        </columnBy>
        <layer type="RowIntervalParallel" boolean:showColoringAsLegendItems="false">
          <drawBy>
            <queryRef>/DrawCallName</queryRef>
          </drawBy>
          <tooltipBy>
            <queryRef>/DrawCallName</queryRef>
            <queryRef>/GPUDrawCallThread</queryRef>
            <queryRef>/DrawCallPurpose</queryRef>
          </tooltipBy>
          <colorBy>
            <queryRef>/DrawCallName</queryRef>
          </colorBy>
        </layer>
      </rowSet>
    </area>
    <area id="gpu_operator_queue">
      <rowSet displayName="%GpuOperators">
        <rowBy>
          <queryRef>/GPUNode</queryRef>
        </rowBy>
        <columnBy>
          <queryRef>/GpuOperatorTime</queryRef>
        </columnBy>
        <layer type="RowIntervalParallel" boolean:showColoringAsLegendItems="false">
          <drawBy>
            <queryRef>/GpuOperator</queryRef>
          </drawBy>
          <tooltipBy>
            <queryRef>/GpuOperator</queryRef>
          </tooltipBy>
          <colorBy>
            <queryRef>/GpuOperator</queryRef>
          </colorBy>
        </layer>
      </rowSet>
    </area>
    <area>
      <rowSet displayName="%GPUSoftQueue">
        <layer type="InstanceCountOverTime">
          <drawBy>
            <queryRef>/GPUQueue</queryRef>
          </drawBy>
        </layer>
      </rowSet>
    </area>
    <area id="gpu_computing_task_and_queue">
      <rowSet>
        <rowBy>
          <queryRef>
            <xsl:value-of select="fnc:get_multi_gpu_grouping()"/>
            <xsl:text>/GPUSourceComputeTask</xsl:text>
          </queryRef>
          <queryRef>/ComputingQueue</queryRef>
        </rowBy>
        <columnBy>
          <queryRef>/GPUComputeTaskTimeGPUName</queryRef>
          <queryRef>/ComputeQueueTime</queryRef>
        </columnBy>
        <sort>
          <queryRef>/GPUComputeTaskTimeGPUName</queryRef>
        </sort>
        <queryMode>allRows</queryMode>
        <layer type="RowIntervalParallel" visibleOnLevels="GPUAdapterAlias,GPUTileName,GPUSourceComputeTask" boolean:showText="true">
          <drawBy>
            <queryRef>/GPUSourceComputeTask</queryRef>
          </drawBy>
          <colorBy>
            <queryRef>/GPUSourceComputeTask</queryRef>
          </colorBy>
          <tooltipBy>
            <queryRef>/GPUComputeTask</queryRef>
            <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
            <queryRef>/GPUComputeSubmitThread</queryRef>
            <queryRef>/GPUComputeGlobalDim</queryRef>
            <queryRef>/GPUComputeLocalDim</queryRef>
            <queryRef>/GPUComputeSimdWidth</queryRef>
          </tooltipBy>
        </layer>
        <layer type="RowInterval" visibleOnLevels="GPUComputeTaskQueueName,ComputeQueueQueueName" boolean:showColoringAsLegendItems="true" boolean:showText="true">
          <drawBy>
            <queryRef>/GPUComputeTask</queryRef>
          </drawBy>
          <highlightBy int:groupId="2">
            <queryRef>/GPUComputeTask</queryRef>
          </highlightBy>
          <tooltipBy>
            <queryRef>/GPUComputeTask</queryRef>
            <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
            <queryRef>/GPUComputeSubmitThread</queryRef>
            <queryRef>/GPUComputeGlobalDim</queryRef>
            <queryRef>/GPUComputeLocalDim</queryRef>
            <queryRef>/GPUComputeSimdWidth</queryRef>
          </tooltipBy>
          <hatchBy>
            <queryRef>/GPUComputeTask</queryRef>
          </hatchBy>
          <colorBy>
            <queryRef>/GPUComputeTask</queryRef>
          </colorBy>
        </layer>
        <layer type="RowIntervalNested" visibleOnLevels="GPUComputeTaskQueueName,ComputeQueueQueueName" boolean:showText="true">
          <drawBy>
            <queryRef>/ComputeQueue</queryRef>
          </drawBy>
          <highlightBy int:groupId="2">
            <queryRef>/ComputeQueue</queryRef>
          </highlightBy>
          <tooltipBy>
            <queryRef>/ComputeQueueTaskName</queryRef>
            <queryRef>/ComputeQueuePurpose</queryRef>
            <queryRef>/ComputeQueueSubmitThread</queryRef>
            <queryRef>/GPUComputeGlobalDimQueue</queryRef>
            <queryRef>/GPUComputeLocalDimQueue</queryRef>
            <queryRef>/GPUComputeSimdWidthQueue</queryRef>
          </tooltipBy>
          <colorBy>
            <queryRef>/ComputeQueue</queryRef>
          </colorBy>
          <hatchBy>
            <queryRef>/ComputeQueue</queryRef>
          </hatchBy>
        </layer>
      </rowSet>
    </area>
  </graphicsTimelineBottom>
</bag>
</xsl:template>
</xsl:stylesheet>
