from collections import OrderedDict
class BreakdownBase:
 def __init__(self):
  self._data={}
 def __radd__(self,other):
  if other==0:
   return self
  else:
   return self.__add__(other)
 def __iter__(self):
  yield from((k,self._get_val(v))for k,v in self._data.items())
 def values(self):
  yield from(self._get_val(v)for v in self._data.values())
 def items(self):
  yield from((k,self._get_val(v))for k,v in self._data.items())
class TimeBreakdown(BreakdownBase):
 def __init__(self):
  super(TimeBreakdown,self).__init__()
 @property
 def times(self):
  return self._data
 def __add__(self,other):
  res=TimeBreakdown()
  if isinstance(other,TimeBreakdown):
   res._data=other._data.copy()
  else:
   res._data=other.copy()
  for reason,time in self._data.items():
   if reason in res._data:
    res._data[reason]+=time
   else:
    res._data[reason]=time
  return res
 def get_total(self):
  return sum(self._data.values())
class Tax:
 def __init__(self,val,count_fn=sum):
  self.val=val
  self.count_fn=count_fn
 def __add__(self,other):
  res=Tax(other.val)
  if isinstance(other,Tax):
   res.count_fn=other.count_fn
   if isinstance(self.val,list):
    res.val=self.val
   else:
    res.val+=self.val
  return res
class TaxBreakdown(BreakdownBase):
 def __init__(self,taxes=None):
  super(TaxBreakdown,self).__init__()
  self._data=OrderedDict()
  if isinstance(taxes,tuple):
   for k,*v in taxes:
    self.__setitem__(k,*v)
  elif isinstance(taxes,dict):
   for k,v in taxes.items():
    self.__setitem__(k,v)
 def __setitem__(self,name,*val):
  self._data[name]=Tax(*val)
 def __getitem__(self,name):
  return self._get_val(self._data[name])
 def _get_val(self,tax):
  return tax.count_fn(self[x]for x in tax.val)if isinstance(tax.val,list)else tax.val
 def __add__(self,other):
  res=TaxBreakdown()
  if isinstance(other,TaxBreakdown):
   res._data=other._data.copy()
  elif isinstance(other,dict):
   res._data=other.copy()
  for k,v in self._data.items():
   if isinstance(v,list):
    res._data[k]=v
   if k in res._data:
    res._data[k]+=v
   else:
    res._data[k]=v
  return res
