'''
This module contains helper functions for command line argument parsing.
Command line arguments are defined into dictionary that has format:
    { # dictionary of arguments
        '<argument_id>': { # <argument_id> is `dest` parameter
                           # of parser.add_argument
            'arg': [ # list of argument definition, required
                ( ('--name1', '--name2'), # tuple of argument names
                {
                    'help': 'Argument help string',
                    'action': '<action>', # <action> is same as `action`
                                          # of parser.add_argument, optional
                    'default': <VALUE>,   # Default value, optional
                    # Parameters that specified here will be passed to
                    # ArgumentParser.add_argument function as kwargs.
                    # So user could add here 'nargs' or 'type' or 'choices'
                    # or any other kwargs that are correct for add_argument
                    # function except 'name' and 'dest'.
                    # 'dest' is '<argument_id>' and
                    # 'name' is tuple of argument names
                } ),
            ],
            'compatibility': { # compatibility of argument, optional
                'advisor': <BUILD_NUM>, # earliest supported Intel Advisor
                                        # version, optional
                'message': '<message>', # message which will be shown
                                        # if requirement not set
            }
        }
    }
'''
from apm_helpers.decorator import cached
import argparse
SUPPRESS_ARG=argparse.SUPPRESS
def add_arguments(parser,arguments,suppress_help=False):
 for key,val in arguments.items():
  for names,kwargs in val['arg']:
   if suppress_help:
    kwargs['help']=argparse.SUPPRESS
   parser.add_argument(*names,dest=key,**kwargs)
def validate_dependencies(parser,args,dependencies):
 for key,val in dependencies.items():
  if getattr(args,key,None)is None:
   for attr,text in val:
    if getattr(args,attr,None)is not None:
     parser.error(text)
@cached
def _get_arguments_by_key(arguments):
 res={}
 for key,val in arguments.items():
  for narg,arg_desc in enumerate(val['arg']):
   for nkey_1,key_1 in enumerate(arg_desc[0]):
    res[key_1]=(key,narg,nkey_1)
 return res
def check_compatibility(current_arg,args,advisor_version,arguments):
 for key,val in _get_arguments_by_key(arguments).items():
  if current_arg.startswith(key):
   arg_desc=arguments[val[0]]
   try:
    min_advisor_version=arg_desc['compatibility']['advisor']
    message=arg_desc['compatibility']['message']
    if advisor_version<min_advisor_version:
     return False,min_advisor_version,message
   except KeyError:
    pass
 return True,0,''
def is_loop_in_selection(loop,selection):
 for loopname in selection:
  try:
   loopID=int(loopname)
   if loop['unique_index']and str(loopID)==loop['unique_index']:
    return True
  except ValueError:
   if loopname==loop['source_location']:
    return True
 return False
def parse_float(x):
 try:
  return float(str(x).replace(',','.'))
 except ValueError:
  raise argparse.ArgumentTypeError('The value {} can not be converted to a floating point number'.format(x))
