#!/bin/csh
#
# Copyright (C) 2020 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

set command=($_)
if ( "$command" != "" ) then
    set script_fn = "$command[2-]"
    set script = `eval "readlink -e $command[2-]"`
    set script_dir = `dirname "$script"`
    set product_dir = `cd "$script_dir/.." && pwd -P`
else
    printf 'ERROR: This script should be sourced\n'
    printf 'Usage:\n'
    printf '\tsource %q\n' "$0"
    exit 2
endif

if ( `uname` == "Darwin" ) then
set bin_dir =
else
    set platform = `uname -m`
    if ( $platform == "x86_64" ) then
set bin_dir = bin64
set lib_dir = lib64
    else
set bin_dir = bin32
set lib_dir = lib32
    endif
    if ! $?PKG_CONFIG_PATH then
        setenv PKG_CONFIG_PATH
    endif
    setenv PKG_CONFIG_PATH "$product_dir/include/pkgconfig/$lib_dir"\:"$PKG_CONFIG_PATH"
endif
setenv PATH "$product_dir/$bin_dir"\:"$PATH"
setenv ADVISOR_2025_DIR "$product_dir"

if ! $?PYTHONPATH then
 setenv PYTHONPATH
endif
setenv PYTHONPATH "$product_dir/pythonapi"\:"${PYTHONPATH}"
setenv APM "$product_dir/perfmodels"
