/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.AllocablePool;
import mpi.Comm;
import mpi.MPIException;

public class MPI {
    private static boolean initialized;
    private static boolean finalized;

    public static int Init(String[] stringArray) throws MPIException {
        if (initialized) {
            throw new MPIException("java.mpi.MPI is already initialized.");
        }
        MPI.initCommon();
        return MPI.MPI_Init(stringArray);
    }

    private static void initCommon() throws MPIException {
        initialized = true;
    }

    protected static void check() throws MPIException {
        if (!initialized) {
            throw new MPIException("java.mpi.MPI is not initialized.");
        }
        if (finalized) {
            throw new MPIException("java.mpi.MPI is finalized.");
        }
    }

    public static void Finalize() throws MPIException {
        MPI.check();
        AllocablePool.cleanUp();
        MPI.MPI_Finalize();
        finalized = true;
    }

    public static double wTime() {
        return MPI.MPI_Wtime();
    }

    public static String getProcessorName() {
        return MPI.MPI_getprocessorname();
    }

    public static void print(String string) throws MPIException {
        MPI.printf_MPI(string);
    }

    public static void println(String string) throws MPIException {
        MPI.printf_MPI(string + "\n");
    }

    public static int getPageSize() {
        return MPI.getpagesize();
    }

    private static native int MPI_Init(String[] var0);

    private static native void MPI_Finalize() throws MPIException;

    private static native void printf_MPI(String var0) throws MPIException;

    private static native double MPI_Wtime();

    private static native String MPI_getprocessorname();

    private static native int getpagesize();

    public static void abort(Comm comm, int n) {
        MPI.MPI_Abort(comm.getHandle(), n);
    }

    public static native void MPI_Abort(long var0, int var2);

    static {
        System.loadLibrary("mpijava");
        initialized = false;
        finalized = false;
    }
}

