/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mpi.Datatype;
import mpi.MPIException;

public abstract class UserFunction {
    private ByteBuffer invec = null;
    private ByteBuffer inoutvec = null;

    public UserFunction(Datatype datatype, int n) throws MPIException {
        this.allocBuffers(datatype, n);
    }

    private void allocBuffers(Datatype datatype, int n) throws MPIException {
        int n2 = 0;
        switch (datatype.getId()) {
            case 1: {
                n2 = n * 8 / 8;
                break;
            }
            case 2: {
                n2 = n * 16 / 8;
                break;
            }
            case 3: {
                n2 = n * 16 / 8;
                break;
            }
            case 5: {
                n2 = n * 32 / 8;
                break;
            }
            case 6: {
                n2 = n * 64 / 8;
                break;
            }
            case 7: {
                n2 = n * 32 / 8;
                break;
            }
            case 8: {
                n2 = n * 64 / 8;
                break;
            }
            default: {
                throw new MPIException("Cannot allocate buffer. You can use byte representation.");
            }
        }
        this.inoutvec = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
        this.invec = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    protected ByteBuffer getInvec() {
        return this.invec;
    }

    protected ByteBuffer getInoutvec() {
        return this.inoutvec;
    }

    protected void setInoutvec(ByteBuffer byteBuffer) {
        this.inoutvec = byteBuffer;
    }

    protected void setInvec(ByteBuffer byteBuffer) {
        this.invec = byteBuffer;
    }

    public abstract void call(int var1, int var2);
}

