/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyLongCopy;
import com.oracle.graal.python.lib.PyLongFromUnicodeObject;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberLongNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.IntegerFormatter;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PInt})
public final class IntBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = IntBuiltinsSlotsGen.SLOTS;

    private static void raiseDivisionByZero(Node inliningTarget, boolean cond, PRaiseNode raiseNode) {
        if (cond) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, raiseNode);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private static void raiseDivisionByZero(Node inliningTarget, PRaiseNode raiseNode) {
        throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_OR_MODULO_BY_ZERO, "integer");
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IntBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.nb_float, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class FloatNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static double doBoolean(boolean self) {
            return self ? 1.0 : 0.0;
        }

        @Specialization
        static double doInt(int self) {
            return self;
        }

        @Specialization
        static double doLong(long self) {
            return self;
        }

        @Specialization
        double doPInt(PInt self) {
            return self.doubleValueWithOverflow(this);
        }

        @Fallback
        static PNotImplemented doGeneric(Object self) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends PythonUnaryBuiltinNode {
        GetNewArgsNode() {
        }

        @Specialization
        static Object doI(Object self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyLongCopy copy) {
            return PFactory.createTuple(language, new Object[]{copy.execute(inliningTarget, self)});
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.nb_int, isComplex=true), @Slot(value=Slot.SlotKind.nb_index, isComplex=true)})
    @GenerateNodeFactory
    static abstract class IntNode
    extends PythonUnaryBuiltinNode {
        IntNode() {
        }

        @Specialization
        static Object doCopy(Object self, @Bind Node inliningTarget, @Cached PyLongCopy copy) {
            return copy.execute(inliningTarget, self);
        }
    }

    @Builtin(name="__trunc__", minNumOfPositionalArgs=1, doc="Truncating an Integral returns itself.")
    @GenerateNodeFactory
    static abstract class TruncNode
    extends IntNode {
        TruncNode() {
        }
    }

    @Builtin(name="as_integer_ratio", minNumOfPositionalArgs=1, doc="Return integer ratio.")
    @GenerateNodeFactory
    static abstract class AsIntegerRatioNode
    extends PythonBuiltinNode {
        AsIntegerRatioNode() {
        }

        @Specialization
        static Object get(VirtualFrame frame, Object self, @Cached IntNode intNode, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, new Object[]{intNode.execute(frame, self), 1});
        }
    }

    @Builtin(name="denominator", minNumOfPositionalArgs=1, isGetter=true, doc="the denominator of a rational number in lowest terms")
    @GenerateNodeFactory
    static abstract class DenominatorNode
    extends PythonBuiltinNode {
        DenominatorNode() {
        }

        @Specialization
        static int get(Object self) {
            return 1;
        }
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1, doc="Returns self, the complex conjugate of any int.")
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends IntNode {
        ConjugateNode() {
        }
    }

    @Builtin(name="numerator", minNumOfPositionalArgs=1, isGetter=true, doc="the numerator of a rational number in lowest terms")
    @GenerateNodeFactory
    static abstract class NumeratorNode
    extends IntNode {
        NumeratorNode() {
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static int get(Object self) {
            return 0;
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends IntNode {
        RealNode() {
        }
    }

    @Builtin(name="is_integer", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class IsIntegerNode
    extends PythonUnaryBuiltinNode {
        IsIntegerNode() {
        }

        @Specialization
        static boolean doLong(long argument) {
            return true;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static boolean doPInt(PInt argument) {
            return true;
        }
    }

    @Builtin(name="bit_length", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class BitLengthNode
    extends PythonUnaryBuiltinNode {
        public abstract int execute(Object var1);

        @Specialization
        static int bitLength(int argument) {
            return 32 - Integer.numberOfLeadingZeros(Math.abs(argument));
        }

        @Specialization
        static int bitLength(long argument) {
            return 64 - Long.numberOfLeadingZeros(Math.abs(argument));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int bitLength(PInt argument) {
            return argument.getValue().abs().bitLength();
        }
    }

    @Builtin(name="bit_count", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class BitCountNode
    extends PythonBuiltinNode {
        BitCountNode() {
        }

        @Specialization
        static int bitCount(int i) {
            return Integer.bitCount(Math.abs(i));
        }

        @Specialization
        static int bitCount(long l) {
            return Long.bitCount(Math.abs(l));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int bitCount(PInt i) {
            return i.getValue().abs().bitCount();
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateUncached
    public static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        @Specialization
        static long hash(int self) {
            return PyObjectHashNode.hash(self);
        }

        @Specialization
        static long hash(long self) {
            return PyObjectHashNode.hash(self);
        }

        @Specialization
        static long hash(PInt self) {
            return self.hash();
        }

        @Specialization(limit="1")
        static long hash(PythonNativeVoidPtr self, @CachedLibrary(value="self.getPointerObject()") InteropLibrary lib) {
            Object object = self.getPointerObject();
            if (lib.hasIdentity(object)) {
                try {
                    return lib.identityHashCode(object);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return HashNode.hashCodeBoundary(object);
        }

        @CompilerDirectives.TruffleBoundary
        private static long hashCodeBoundary(Object object) {
            return object.hashCode();
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IntBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static TruffleString formatB(boolean self, TruffleString formatString, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return FormatNode.formatI(self ? 1 : 0, formatString, inliningTarget, raiseNode);
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static TruffleString formatI(int self, TruffleString formatString, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            InternalFormat.Spec spec = FormatNode.getSpec(formatString, inliningTarget);
            if (FormatNode.isDoubleSpec(spec)) {
                return FormatNode.formatDouble(spec, self, inliningTarget);
            }
            FormatNode.validateIntegerSpec(inliningTarget, raiseNode, spec);
            return FormatNode.formatInt(self, spec, inliningTarget);
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static TruffleString formatL(VirtualFrame frame, long self, TruffleString formatString, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PyNumberFloatNode floatNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return FormatNode.formatPI(frame, PFactory.createInt(language, self), formatString, inliningTarget, floatNode, raiseNode);
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static TruffleString formatPI(VirtualFrame frame, PInt self, TruffleString formatString, @Bind Node inliningTarget, @Cached.Shared @Cached PyNumberFloatNode floatNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            InternalFormat.Spec spec = FormatNode.getSpec(formatString, inliningTarget);
            if (FormatNode.isDoubleSpec(spec)) {
                double doubleVal = FormatNode.asDouble(frame, inliningTarget, floatNode, self);
                return FormatNode.formatDouble(spec, doubleVal, inliningTarget);
            }
            FormatNode.validateIntegerSpec(inliningTarget, raiseNode, spec);
            return FormatNode.formatPInt(self, spec, inliningTarget);
        }

        private static double asDouble(VirtualFrame frame, Node inliningTarget, PyNumberFloatNode floatNode, Object self) {
            return floatNode.execute((Frame)frame, inliningTarget, self);
        }

        private static InternalFormat.Spec getSpec(TruffleString formatString, Node raisingNode) {
            return InternalFormat.fromText(formatString, 'd', '>', raisingNode);
        }

        private static boolean isDoubleSpec(InternalFormat.Spec spec) {
            return spec.type == 'e' || spec.type == 'E' || spec.type == 'f' || spec.type == 'F' || spec.type == 'g' || spec.type == 'G' || spec.type == '%';
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatDouble(InternalFormat.Spec spec, double value, Node raisingNode) {
            FloatFormatter formatter = new FloatFormatter(spec, raisingNode);
            formatter.format(value);
            return formatter.pad().getResult();
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatInt(int self, InternalFormat.Spec spec, Node raisingNode) {
            IntegerFormatter formatter = new IntegerFormatter(spec, raisingNode);
            formatter.format(self);
            return formatter.pad().getResult();
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatPInt(PInt self, InternalFormat.Spec spec, Node raisingNode) {
            IntegerFormatter formatter = new IntegerFormatter(spec, raisingNode);
            formatter.format(self.getValue());
            return formatter.pad().getResult();
        }

        private static void validateIntegerSpec(Node inliningTarget, PRaiseNode raiseNode, InternalFormat.Spec spec) {
            if (InternalFormat.Spec.specified(spec.precision)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.PRECISION_NOT_ALLOWED_FOR_INT);
            }
            if (spec.type == 'c') {
                if (InternalFormat.Spec.specified(spec.sign)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SIGN_NOT_ALLOWED_WITH_C_FOR_INT);
                }
                if (spec.alternate) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ALTERNATE_NOT_ALLOWED_WITH_C_FOR_INT);
                }
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        ReprNode() {
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static TruffleString doL(long self, @Cached.Shared(value="fromLong") @Cached TruffleString.FromLongNode fromLongNode) {
            return fromLongNode.execute(self, PythonUtils.TS_ENCODING, false);
        }

        @Specialization
        static TruffleString doPInt(PInt self, @Bind Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached InlinedIntValueProfile maxDigitsProfile, @Cached InlinedIntValueProfile maxDigitsBitLengthProfile, @Cached PRaiseNode raiseNode) {
            int bitLength;
            PythonContext context = PythonContext.get(inliningTarget);
            int intMaxStrDigits = maxDigitsProfile.profile(inliningTarget, context.getIntMaxStrDigits());
            if (intMaxStrDigits > 0 && (bitLength = StrNode.positiveBitLength(self)) >= maxDigitsBitLengthProfile.profile(inliningTarget, context.getMinIntBitLengthOverLimit())) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EXCEEDS_THE_LIMIT_FOR_INTEGER_STRING_CONVERSION, intMaxStrDigits);
            }
            String value = self.toString();
            if (intMaxStrDigits > 0) {
                int digits;
                int n = digits = self.isNegative() ? value.length() - 1 : value.length();
                if (digits > intMaxStrDigits) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EXCEEDS_THE_LIMIT_FOR_INTEGER_STRING_CONVERSION);
                }
            }
            return fromJavaStringNode.execute(value, PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static int positiveBitLength(PInt self) {
            return self.abs().bitLength();
        }

        @Specialization
        static TruffleString doNativeVoidPtr(VirtualFrame frame, PythonNativeVoidPtr self, @Bind Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached.Shared(value="fromLong") @Cached TruffleString.FromLongNode fromLongNode) {
            return StrNode.doL(hashNode.execute((Frame)frame, inliningTarget, self), fromLongNode);
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        @Specialization
        static boolean toBoolean(boolean self) {
            return self;
        }

        @Specialization
        static boolean toBoolean(int self) {
            return self != 0;
        }

        @Specialization
        static boolean toBoolean(long self) {
            return self != 0L;
        }

        @Specialization
        static boolean toBoolean(PInt self) {
            return !self.isZero();
        }

        @Specialization
        static boolean toBoolean(PythonNativeVoidPtr self, @CachedLibrary(limit="1") InteropLibrary lib) {
            return !lib.isNull(self.getPointerObject());
        }
    }

    @Builtin(name="from_bytes", minNumOfPositionalArgs=2, parameterNames={"cls", "bytes", "byteorder"}, keywordOnlyNames={"signed"}, isClassmethod=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="byteorder", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_BIG"), @ArgumentClinic(name="signed", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateNodeFactory
    public static abstract class FromBytesNode
    extends PythonClinicBuiltinNode {
        @Specialization
        static Object fromObject(VirtualFrame frame, Object cl, Object object, TruffleString byteorder, boolean signed, @Bind Node inliningTarget, @Cached(value="create(T___BYTES__)") LookupAndCallUnaryNode callBytes, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinIntProfile, @Cached InlinedBranchProfile hasBytesProfile, @Cached TruffleString.EqualNode equalNode, @Cached BytesNodes.BytesFromObject bytesFromObject, @Cached IntNodes.PyLongFromByteArray fromByteArray, @Cached CallNode callCtor, @Cached PRaiseNode raiseNode) {
            byte[] bytes;
            boolean littleEndian;
            if (equalNode.execute((AbstractTruffleString)byteorder, (AbstractTruffleString)StringLiterals.T_BIG, PythonUtils.TS_ENCODING)) {
                littleEndian = false;
            } else if (equalNode.execute((AbstractTruffleString)byteorder, (AbstractTruffleString)StringLiterals.T_LITTLE, PythonUtils.TS_ENCODING)) {
                littleEndian = true;
            } else {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.BYTEORDER_MUST_BE_LITTLE_OR_BIG);
            }
            Object bytesObj = callBytes.executeObject(frame, object);
            if (bytesObj != PNone.NO_VALUE) {
                hasBytesProfile.enter(inliningTarget);
                if (!(bytesObj instanceof PBytes)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.RETURNED_NONBYTES, SpecialMethodNames.T___BYTES__);
                }
                bytes = bufferLib.getCopiedByteArray(bytesObj);
            } else {
                bytes = bytesFromObject.execute(frame, object);
            }
            Object result = fromByteArray.execute(inliningTarget, bytes, littleEndian, signed);
            if (isBuiltinIntProfile.profileClass(inliningTarget, cl, PythonBuiltinClassType.PInt)) {
                return result;
            }
            return callCtor.execute((Frame)frame, cl, result);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IntBuiltinsClinicProviders.FromBytesNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="to_bytes", minNumOfPositionalArgs=1, parameterNames={"$self", "length", "byteorder"}, keywordOnlyNames={"signed"})
    @ArgumentsClinic(value={@ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="1"), @ArgumentClinic(name="byteorder", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_BIG"), @ArgumentClinic(name="signed", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class ToBytesNode
    extends PythonClinicBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private static boolean isBigEndian(Node raisingNode, TruffleString order) {
            if (order.equalsUncached((AbstractTruffleString)StringLiterals.T_BIG, PythonUtils.TS_ENCODING)) {
                return true;
            }
            if (order.equalsUncached((AbstractTruffleString)StringLiterals.T_LITTLE, PythonUtils.TS_ENCODING)) {
                return false;
            }
            throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.ValueError, ErrorMessages.BYTEORDER_MUST_BE_LITTLE_OR_BIG);
        }

        @Specialization
        static PBytes fromLong(long self, int byteCount, TruffleString byteorder, boolean signed, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached InlinedConditionProfile negativeByteCountProfile, @Cached.Exclusive @Cached InlinedConditionProfile negativeNumberProfile, @Cached.Exclusive @Cached InlinedConditionProfile overflowProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (negativeByteCountProfile.profile(inliningTarget, byteCount < 0)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MESSAGE_LENGTH_ARGUMENT);
            }
            if (self < 0L && negativeNumberProfile.profile(inliningTarget, !signed)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.MESSAGE_CONVERT_NEGATIVE);
            }
            return PFactory.createBytes(language, ToBytesNode.fromLong(self, byteCount, ToBytesNode.isBigEndian(inliningTarget, byteorder), signed, inliningTarget, overflowProfile, raiseNode));
        }

        public static byte[] fromLong(long self, int byteCount, boolean isBigEndian, boolean signed, Node inliningTarget, InlinedConditionProfile overflowProfile, PRaiseNode raiseNode) {
            long number;
            int delta;
            int index;
            int signByte = 0;
            if (self < 0L) {
                assert (signed) : ErrorMessages.MESSAGE_CONVERT_NEGATIVE;
                signByte = -1;
            }
            if (isBigEndian) {
                index = byteCount - 1;
                delta = -1;
            } else {
                index = 0;
                delta = 1;
            }
            byte[] bytes = new byte[byteCount];
            for (number = self; number != 0L && 0 <= index && index <= byteCount - 1; number >>= 8, index += delta) {
                bytes[index] = (byte)(number & 0xFFL);
                if (number != (long)signByte) continue;
                number = 0L;
            }
            if (overflowProfile.profile(inliningTarget, !signed && number != 0L || signed && bytes.length == 1 && (long)bytes[0] != self || byteCount == 0 && self != 0L && self != -1L)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.MESSAGE_INT_TO_BIG);
            }
            if (signed) {
                while (0 <= index && index <= byteCount - 1) {
                    bytes[index] = signByte;
                    index += delta;
                }
            }
            return bytes;
        }

        @CompilerDirectives.TruffleBoundary
        private static byte getSignByte(BigInteger value, boolean signed, Node raisingNode) {
            if (value.compareTo(BigInteger.ZERO) < 0) {
                if (!signed) {
                    throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.OverflowError, ErrorMessages.MESSAGE_CONVERT_NEGATIVE);
                }
                return -1;
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] getBytes(BigInteger value) {
            return value.toByteArray();
        }

        @Specialization
        static PBytes fromPIntInt(PInt self, int byteCount, TruffleString byteorder, boolean signed, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached InlinedConditionProfile negativeByteCountProfile, @Cached.Exclusive @Cached InlinedConditionProfile overflowProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (negativeByteCountProfile.profile(inliningTarget, byteCount < 0)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MESSAGE_LENGTH_ARGUMENT);
            }
            return PFactory.createBytes(language, ToBytesNode.fromBigInteger(self, byteCount, ToBytesNode.isBigEndian(inliningTarget, byteorder), signed, inliningTarget, overflowProfile, raiseNode));
        }

        public static byte[] fromBigInteger(PInt self, int byteCount, boolean isBigEndian, boolean signed, Node inliningTarget, InlinedConditionProfile overflowProfile, PRaiseNode raiseNode) {
            int i;
            BigInteger value = self.getValue();
            byte signByte = ToBytesNode.getSignByte(value, signed, inliningTarget);
            byte[] bytes = ToBytesNode.getBytes(value);
            if (bytes.length > byteCount) {
                int len = bytes.length;
                int startIndex = 0;
                if (!signed) {
                    for (startIndex = 0; startIndex < bytes.length && bytes[startIndex] == 0; ++startIndex) {
                    }
                    len = Math.max(bytes.length - startIndex, byteCount);
                }
                if (overflowProfile.profile(inliningTarget, len > byteCount)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.MESSAGE_INT_TO_BIG);
                }
                byte[] tmp = bytes;
                bytes = new byte[len];
                PythonUtils.arraycopy(tmp, startIndex, bytes, 0, len);
            }
            if (isBigEndian) {
                if (byteCount > bytes.length) {
                    byte[] resultBytes = new byte[byteCount];
                    PythonUtils.arraycopy(bytes, 0, resultBytes, resultBytes.length - bytes.length, bytes.length);
                    if (signByte == -1) {
                        for (i = 0; i < resultBytes.length - bytes.length; ++i) {
                            resultBytes[i] = signByte;
                        }
                    }
                    return resultBytes;
                }
                return bytes;
            }
            byte[] resultBytes = new byte[byteCount];
            for (i = 0; i < bytes.length; ++i) {
                resultBytes[i] = bytes[bytes.length - 1 - i];
            }
            if (byteCount > bytes.length && signByte == -1) {
                for (i = bytes.length; i < resultBytes.length; ++i) {
                    resultBytes[i] = signByte;
                }
            }
            return resultBytes;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IntBuiltinsClinicProviders.ToBytesNodeClinicProviderGen.INSTANCE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class RichCompareNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        RichCompareNode() {
        }

        @Specialization(guards={"opCode == cachedOp"}, limit="6")
        static Object doCached(VirtualFrame frame, Object left, Object right, RichCmpOp opCode, @Bind Node inliningTarget, @Cached PyLongCheckNode checkLeft, @Cached PyLongCheckNode checkRight, @Cached(value="opCode") RichCmpOp cachedOp, @Cached RichCompareHelperNode cmpNode) {
            if (!checkLeft.execute(inliningTarget, left) || !checkRight.execute(inliningTarget, right)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return cmpNode.execute(frame, inliningTarget, left, right, cachedOp);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @ImportStatic(value={CExtNodes.FromNativeSubclassNode.class})
    static abstract class RichCompareHelperNode
    extends Node {
        RichCompareHelperNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, RichCmpOp var5);

        @Specialization
        static boolean doII(int left, int right, RichCmpOp op) {
            return op.compareResultToBool(Integer.compare(left, right));
        }

        @Specialization
        static boolean doLL(long left, long right, RichCmpOp op) {
            return op.compareResultToBool(Long.compare(left, right));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static boolean doLPExact(long left, PInt right, RichCmpOp op) throws OverflowException {
            return op.compareResultToBool(Long.compare(left, right.longValueExact()));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static boolean doPLExact(PInt left, long right, RichCmpOp op) throws OverflowException {
            return op.compareResultToBool(Long.compare(left.longValueExact(), right));
        }

        @Specialization(replaces={"doLPExact"})
        static boolean doLP(long left, PInt right, RichCmpOp op) {
            return op.compareResultToBool(PInt.compareTo(left, right));
        }

        @Specialization(replaces={"doPLExact"})
        static boolean doPL(PInt left, long right, RichCmpOp op) {
            return op.compareResultToBool(left.compareTo(right));
        }

        @Specialization
        static boolean doPP(PInt left, PInt right, RichCmpOp op) {
            return op.compareResultToBool(left.compareTo(right));
        }

        @Specialization(guards={"isFloatSubtype(inliningTarget, y, getClass, isSubtype)"})
        @HostCompilerDirectives.InliningCutoff
        static boolean doDN(VirtualFrame frame, Node inliningTarget, long x, PythonAbstractNativeObject y, RichCmpOp op, @Cached.Shared @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached.Shared @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeRight) {
            return op.compareResultToBool(PFloat.compare(x, nativeRight.execute(frame, y)));
        }

        @Specialization(guards={"isFloatSubtype(inliningTarget, x, getClass, isSubtype)", "isFloatSubtype(inliningTarget, y, getClass, isSubtype)"})
        @HostCompilerDirectives.InliningCutoff
        static boolean doDN(VirtualFrame frame, Node inliningTarget, PythonAbstractNativeObject x, PythonAbstractNativeObject y, RichCmpOp op, @Cached.Shared @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached.Shared @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeLeft, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeRight) {
            return op.compareResultToBool(PFloat.compare(nativeLeft.execute(frame, x), nativeRight.execute(frame, y)));
        }

        @Specialization(guards={"isFloatSubtype(inliningTarget, x, getClass, isSubtype)"})
        @HostCompilerDirectives.InliningCutoff
        static boolean doDN(VirtualFrame frame, Node inliningTarget, PythonAbstractNativeObject x, double y, RichCmpOp op, @Cached.Shared @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached.Shared @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeLeft) {
            return op.compareResultToBool(PFloat.compare(nativeLeft.execute(frame, x), y));
        }

        static boolean someIsNativePtr(Object a, Object b) {
            return a instanceof PythonNativeVoidPtr || b instanceof PythonNativeVoidPtr;
        }

        @Specialization(guards={"someIsNativePtr(x, y)"})
        @HostCompilerDirectives.InliningCutoff
        static Object doVoidPtr(VirtualFrame frame, Node inliningTarget, Object x, Object y, RichCmpOp op, @Cached CExtNodes.PointerCompareNode pointerCompareNode, @Cached EqNodeNativePtr pointerEqNode) {
            if (op.isEqOrNe()) {
                Object result = pointerEqNode.execute(frame, x, y);
                if (result == PNotImplemented.NOT_IMPLEMENTED) {
                    return result;
                }
                return ((Boolean)result).booleanValue() == op.isEq();
            }
            return pointerCompareNode.execute(inliningTarget, op, x, y);
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @GenerateInline(value=false)
        @TypeSystemReference(value=PythonIntegerTypes.class)
        static abstract class EqNodeNativePtr
        extends PNodeWithContext {
            EqNodeNativePtr() {
            }

            abstract Object execute(VirtualFrame var1, Object var2, Object var3);

            @Specialization
            static boolean eqLongVoidPtr(VirtualFrame frame, long a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
                return EqNodeNativePtr.eqVoidPtrLong(frame, b, a, inliningTarget, hashNode);
            }

            @Specialization
            static boolean eqPIntVoidPtr(PInt a, PythonNativeVoidPtr b) {
                return EqNodeNativePtr.eqVoidPtrPInt(b, a);
            }

            @Specialization
            static boolean eqVoidPtrLong(VirtualFrame frame, PythonNativeVoidPtr a, long b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
                if (a.isNativePointer()) {
                    long ptrVal = a.getNativePointer();
                    return ptrVal == b;
                }
                return hashNode.execute((Frame)frame, inliningTarget, a) == b;
            }

            @Specialization(guards={"a.isNativePointer()", "b.isNativePointer()"})
            static boolean voidPtrsNative(PythonNativeVoidPtr a, PythonNativeVoidPtr b) {
                long ptrVal = a.getNativePointer();
                return ptrVal == b.getNativePointer();
            }

            @Specialization(guards={"a.isNativePointer()", "!b.isNativePointer()"})
            static boolean voidPtrsANative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
                long ptrVal = a.getNativePointer();
                return ptrVal == hashNode.execute((Frame)frame, inliningTarget, b);
            }

            @Specialization(guards={"!a.isNativePointer()", "b.isNativePointer()"})
            static boolean voidPtrsBNative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
                long ptrVal = b.getNativePointer();
                return ptrVal == hashNode.execute((Frame)frame, inliningTarget, a);
            }

            @Specialization(guards={"!a.isNativePointer()", "!b.isNativePointer()"})
            static boolean voidPtrsManaged(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
                return hashNode.execute((Frame)frame, inliningTarget, a) == hashNode.execute((Frame)frame, inliningTarget, b);
            }

            @Specialization
            @CompilerDirectives.TruffleBoundary
            static boolean eqVoidPtrPInt(PythonNativeVoidPtr a, PInt b) {
                if (a.isNativePointer()) {
                    long ptrVal = a.getNativePointer();
                    if (ptrVal < 0L) {
                        BigInteger bi = PInt.longToBigInteger(ptrVal).add(BigInteger.ONE.shiftLeft(64));
                        return bi.equals(b.getValue());
                    }
                    return PInt.longToBigInteger(ptrVal).equals(b.getValue());
                }
                try {
                    return PyObjectHashNode.executeUncached(a) == b.longValueExact();
                }
                catch (OverflowException e) {
                    return false;
                }
            }

            @Fallback
            static PNotImplemented doGeneric(Object a, Object b) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
        }
    }

    @Slot(value=Slot.SlotKind.nb_xor, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    public static abstract class XorNode
    extends BinaryBitwiseNode {
        @Override
        protected int op(int left, int right) {
            return left ^ right;
        }

        @Override
        protected long op(long left, long right) {
            return left ^ right;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public BigInteger op(BigInteger left, BigInteger right) {
            return left.xor(right);
        }

        @NeverDefault
        public static XorNode create() {
            return IntBuiltinsFactory.XorNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    public static abstract class OrNode
    extends BinaryBitwiseNode {
        @Override
        protected int op(int left, int right) {
            return left | right;
        }

        @Override
        protected long op(long left, long right) {
            return left | right;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final BigInteger op(BigInteger left, BigInteger right) {
            return left.or(right);
        }

        @NeverDefault
        public static OrNode create() {
            return IntBuiltinsFactory.OrNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_and, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    public static abstract class AndNode
    extends BinaryBitwiseNode {
        @Override
        protected int op(int left, int right) {
            return left & right;
        }

        @Override
        protected long op(long left, long right) {
            return left & right;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected final BigInteger op(BigInteger left, BigInteger right) {
            return left.and(right);
        }

        @NeverDefault
        public static AndNode create() {
            return IntBuiltinsFactory.AndNodeFactory.create();
        }
    }

    @GenerateCached(value=false)
    static abstract class BinaryBitwiseNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        BinaryBitwiseNode() {
        }

        protected int op(int left, int right) {
            throw CompilerDirectives.shouldNotReachHere((String)"should not reach here");
        }

        protected long op(long left, long right) {
            throw CompilerDirectives.shouldNotReachHere((String)"should not reach here");
        }

        protected BigInteger op(BigInteger left, BigInteger right) {
            throw CompilerDirectives.shouldNotReachHere((String)"should not reach here");
        }

        @Specialization
        int doInteger(int left, int right) {
            return this.op(left, right);
        }

        @Specialization
        long doInteger(long left, long right) {
            return this.op(left, right);
        }

        @Specialization(guards={"a.isNativePointer()"})
        Object opVoidNativePtrLong(PythonNativeVoidPtr a, long b) {
            if (a.isNativePointer()) {
                return this.op(a.getNativePointer(), b);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"!a.isNativePointer()"})
        Object opVoidPtrLong(VirtualFrame frame, PythonNativeVoidPtr a, long b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            return this.op(hashNode.execute((Frame)frame, inliningTarget, a), b);
        }

        @Specialization(guards={"a.isNativePointer()", "b.isNativePointer()"})
        long voidPtrsNative(PythonNativeVoidPtr a, PythonNativeVoidPtr b) {
            long ptrVal = a.getNativePointer();
            return this.op(ptrVal, b.getNativePointer());
        }

        @Specialization(guards={"a.isNativePointer()", "!b.isNativePointer()"})
        long voidPtrsANative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            long ptrVal = a.getNativePointer();
            return this.op(ptrVal, hashNode.execute((Frame)frame, inliningTarget, b));
        }

        @Specialization(guards={"!a.isNativePointer()", "b.isNativePointer()"})
        long voidPtrsBNative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            long ptrVal = b.getNativePointer();
            return this.op(ptrVal, hashNode.execute((Frame)frame, inliningTarget, a));
        }

        @Specialization(guards={"!a.isNativePointer()", "!b.isNativePointer()"})
        long voidPtrsManaged(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            return this.op(hashNode.execute((Frame)frame, inliningTarget, a), hashNode.execute((Frame)frame, inliningTarget, b));
        }

        @Specialization
        PInt doPInt(long left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, this.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization
        PInt doPInt(PInt left, long right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, this.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization
        PInt doPInt(PInt left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, this.op(left.getValue(), right.getValue()));
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.nb_rshift, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    public static abstract class RShiftNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract int executeInt(int var1, int var2) throws UnexpectedResultException;

        public abstract Object execute(int var1, int var2);

        @Specialization(guards={"right < 32"})
        static int doIISmall(int left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0, raiseNode);
            return left >> right;
        }

        @Specialization(replaces={"doIISmall"})
        static int doII(int left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0, raiseNode);
            return left >> (right >= 32 ? 31 : right);
        }

        @Specialization(guards={"right < 64"})
        static long doLLSmall(long left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0L, raiseNode);
            return left >> (int)right;
        }

        @Specialization(replaces={"doLLSmall"})
        static long doLL(long left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0L, raiseNode);
            return left >> (int)(right >= 64L ? 63L : right);
        }

        @Specialization
        static Object doIPi(int left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return RShiftNode.doHugeShift(inliningTarget, PInt.longToBigInteger(left), right, raiseNode);
        }

        @Specialization
        static Object doLPi(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return RShiftNode.doHugeShift(inliningTarget, PInt.longToBigInteger(left), right, raiseNode);
        }

        @Specialization
        static PInt doPiI(PInt left, int right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0, raiseNode);
            return PFactory.createInt(language, RShiftNode.op(left.getValue(), right));
        }

        @Specialization
        static Object doPiL(PInt left, long right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0L, raiseNode);
            int rightI = (int)right;
            if ((long)rightI == right) {
                return PFactory.createInt(language, RShiftNode.op(left.getValue(), rightI));
            }
            return left.isNegative() ? -1 : 0;
        }

        @Specialization
        static Object doPInt(PInt left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return RShiftNode.doHugeShift(inliningTarget, left.getValue(), right, raiseNode);
        }

        private static void raiseNegativeShiftCount(Node inliningTarget, boolean cond, PRaiseNode raiseNode) {
            if (cond) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SHIFT_COUNT);
            }
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        private static Object doHugeShift(Node inliningTarget, BigInteger left, PInt right, PRaiseNode raiseNode) {
            RShiftNode.raiseNegativeShiftCount(inliningTarget, !right.isZeroOrPositive(), raiseNode);
            try {
                return PFactory.createInt(PythonLanguage.get(inliningTarget), RShiftNode.op(left, right.intValueExact()));
            }
            catch (OverflowException e) {
                return left.signum() < 0 ? -1 : 0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(BigInteger left, int right) {
            return left.shiftRight(right);
        }

        @NeverDefault
        public static RShiftNode create() {
            return IntBuiltinsFactory.RShiftNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_lshift, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class LShiftNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract int executeInt(int var1, int var2) throws UnexpectedResultException;

        public abstract Object execute(int var1, int var2);

        private static long leftShiftExact(Node inliningTarget, long left, long right, PRaiseNode raiseNode) throws OverflowException {
            long result;
            if (right >= 64L || right < 0L) {
                LShiftNode.shiftError(inliningTarget, right, raiseNode);
            }
            if (left != (result = left << (int)right) >> (int)right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        private static int leftShiftExact(Node inliningTarget, int left, int right, PRaiseNode raiseNode) throws OverflowException {
            int result;
            if (right >= 32 || right < 0) {
                LShiftNode.shiftError(inliningTarget, right, raiseNode);
            }
            if (left != (result = left << right) >> right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        private static void shiftError(Node inliningTarget, long shiftCount, PRaiseNode raiseNode) throws OverflowException {
            if (shiftCount >= 32L) {
                throw OverflowException.INSTANCE;
            }
            if (shiftCount < 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SHIFT_COUNT);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static int doII(int left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0, raiseNode);
            return LShiftNode.leftShiftExact(inliningTarget, left, right, raiseNode);
        }

        @Specialization
        static Object doIIOvf(int left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0, raiseNode);
            try {
                return LShiftNode.leftShiftExact(inliningTarget, left, right, raiseNode);
            }
            catch (OverflowException e) {
                return LShiftNode.doGuardedBiI(inliningTarget, PInt.longToBigInteger(left), right, raiseNode);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doLL(long left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0L, raiseNode);
            return LShiftNode.leftShiftExact(inliningTarget, left, right, raiseNode);
        }

        @Specialization
        static Object doILOvf(int left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return LShiftNode.doLLOvf(left, right, inliningTarget, raiseNode);
        }

        @Specialization
        static Object doLIOvf(long left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return LShiftNode.doLLOvf(left, right, inliningTarget, raiseNode);
        }

        @Specialization
        static Object doLLOvf(long left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0L, raiseNode);
            try {
                return LShiftNode.leftShiftExact(inliningTarget, left, right, raiseNode);
            }
            catch (OverflowException e) {
                int rightI = (int)right;
                if ((long)rightI == right) {
                    try {
                        return PFactory.createInt(PythonLanguage.get(inliningTarget), LShiftNode.op(PInt.longToBigInteger(left), rightI));
                    }
                    catch (OverflowException overflowException) {
                        // empty catch block
                    }
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError);
            }
        }

        @Specialization(guards={"left == 0", "right.isZeroOrPositive()"})
        static int doIPiZero(int left, PInt right) {
            return 0;
        }

        @Specialization(replaces={"doIPiZero"})
        static PInt doIPi(int left, PInt right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, !right.isZeroOrPositive(), raiseNode);
            if (left == 0) {
                return PFactory.createInt(language, BigInteger.ZERO);
            }
            try {
                int iright = right.intValueExact();
                return PFactory.createInt(language, LShiftNode.op(PInt.longToBigInteger(left), iright));
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError);
            }
        }

        @Specialization(guards={"left == 0", "right.isZeroOrPositive()"})
        static int doLPiZero(long left, PInt right) {
            return 0;
        }

        @Specialization(replaces={"doLPiZero"})
        static PInt doLPi(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, !right.isZeroOrPositive(), raiseNode);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            if (left == 0L) {
                return PFactory.createInt(language, BigInteger.ZERO);
            }
            try {
                int iright = right.intValueExact();
                return PFactory.createInt(language, LShiftNode.op(PInt.longToBigInteger(left), iright));
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError);
            }
        }

        @Specialization
        static PInt doPiI(PInt left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0, raiseNode);
            return LShiftNode.doGuardedBiI(inliningTarget, left.getValue(), right, raiseNode);
        }

        static PInt doGuardedBiI(Node inliningTarget, BigInteger left, int right, PRaiseNode raiseNode) {
            try {
                return PFactory.createInt(PythonLanguage.get(inliningTarget), LShiftNode.op(left, right));
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError);
            }
        }

        @Specialization
        static PInt doPiL(PInt left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, right < 0L, raiseNode);
            int rightI = (int)right;
            if ((long)rightI == right) {
                return LShiftNode.doGuardedBiI(inliningTarget, left.getValue(), rightI, raiseNode);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError);
        }

        @Specialization(guards={"left.isZero()", "right.isZeroOrPositive()"})
        static int doPiPiZero(PInt left, PInt right) {
            return 0;
        }

        @Specialization(replaces={"doPiPiZero"})
        static PInt doPiPi(PInt left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            LShiftNode.raiseNegativeShiftCount(inliningTarget, !right.isZeroOrPositive(), raiseNode);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            if (left.isZero()) {
                return PFactory.createInt(language, BigInteger.ZERO);
            }
            try {
                return PFactory.createInt(language, LShiftNode.op(left.getValue(), right.intValueExact()));
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError);
            }
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger op(BigInteger left, int right) throws OverflowException {
            try {
                return left.shiftLeft(right);
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        private static void raiseNegativeShiftCount(Node inliningTarget, boolean cond, PRaiseNode raiseNode) {
            if (cond) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SHIFT_COUNT);
            }
        }

        @NeverDefault
        public static LShiftNode create() {
            return IntBuiltinsFactory.LShiftNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_invert, isComplex=true)
    @GenerateNodeFactory
    static abstract class InvertNode
    extends PythonUnaryBuiltinNode {
        InvertNode() {
        }

        @CompilerDirectives.TruffleBoundary
        private static void warnBoolInvert() {
            WarningsModuleBuiltins.WarnNode.getUncached().warnEx(null, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.BITWISE_INVERSION_OF_THE_UNDERLYING_INT, 1);
        }

        @Specialization
        static int neg(boolean arg) {
            InvertNode.warnBoolInvert();
            return ~(arg ? 1 : 0);
        }

        @Specialization
        static int neg(int arg) {
            return ~arg;
        }

        @Specialization
        static long neg(long arg) {
            return arg ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Specialization
        static PInt doPInt(PInt operand, @Bind PythonLanguage language) {
            return PFactory.createInt(language, InvertNode.not(operand.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger not(BigInteger value) {
            return value.not();
        }
    }

    @Slot(value=Slot.SlotKind.nb_negative, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NegNode
    extends PythonUnaryBuiltinNode {
        public abstract Object execute(int var1);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int neg(int arg) {
            return Math.negateExact(arg);
        }

        @Specialization
        static long negOvf(int arg) {
            return -((long)arg);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long neg(long arg) {
            return Math.negateExact(arg);
        }

        @Specialization
        static PInt negOvf(long arg, @Bind PythonLanguage language) {
            BigInteger value = arg == Long.MIN_VALUE ? NegNode.negate(PInt.longToBigInteger(arg)) : PInt.longToBigInteger(-arg);
            return PFactory.createInt(language, value);
        }

        @Specialization
        static PInt doPInt(PInt operand, @Bind PythonLanguage language) {
            return PFactory.createInt(language, NegNode.negate(operand.getValue()));
        }

        @Specialization
        static int doBoolean(boolean arg) {
            return -PInt.intValue(arg);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger negate(BigInteger value) {
            return value.negate();
        }

        @NeverDefault
        public static NegNode create() {
            return IntBuiltinsFactory.NegNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_positive, isComplex=true)
    @GenerateNodeFactory
    static abstract class PosNode
    extends PythonUnaryBuiltinNode {
        PosNode() {
        }

        @Specialization
        static Integer pos(Integer arg) {
            return arg;
        }

        @Specialization
        static Long pos(Long arg) {
            return arg;
        }

        @Specialization
        static PInt pos(PInt arg, @Bind PythonLanguage language) {
            return PFactory.createInt(language, arg.getValue());
        }

        @Specialization
        static int pos(boolean arg) {
            return PInt.intValue(arg);
        }
    }

    @Builtin(name="__floor__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class FloorNode
    extends PythonUnaryBuiltinNode {
        FloorNode() {
        }

        @Specialization
        static int floor(int arg) {
            return arg;
        }

        @Specialization
        static long floor(long arg) {
            return arg;
        }

        @Specialization
        static PInt floor(PInt arg, @Bind PythonLanguage language) {
            return PFactory.createInt(language, arg.getValue());
        }
    }

    @Builtin(name="__ceil__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class CeilNode
    extends PythonUnaryBuiltinNode {
        CeilNode() {
        }

        @Specialization
        static int ceil(int arg) {
            return arg;
        }

        @Specialization
        static long ceil(long arg) {
            return arg;
        }

        @Specialization
        static PInt ceil(PInt arg) {
            return arg;
        }
    }

    @Slot(value=Slot.SlotKind.nb_absolute, isComplex=true)
    @GenerateNodeFactory
    static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        AbsNode() {
        }

        @Specialization
        static Object absInt(int arg) {
            return PInt.abs(arg);
        }

        @Specialization
        static Object absLong(long arg, @Bind Node inliningTarget) {
            return PInt.abs(inliningTarget, arg);
        }

        @Specialization
        static PInt absPInt(PInt arg, @Bind PythonLanguage language) {
            return PFactory.createInt(language, arg.abs());
        }

        @Specialization
        static int absBoolean(boolean arg) {
            return arg ? 1 : 0;
        }
    }

    @Slot(value=Slot.SlotKind.nb_power, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @ImportStatic(value={MathGuards.class})
    @ReportPolymorphism
    public static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        protected abstract int executeInt(int var1, int var2, PNone var3) throws UnexpectedResultException;

        protected abstract Object execute(int var1, int var2, PNone var3);

        public final int executeInt(int left, int right) throws UnexpectedResultException {
            return this.executeInt(left, right, PNone.NO_VALUE);
        }

        public final Object execute(int left, int right) {
            return this.execute(left, right, PNone.NO_VALUE);
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={ArithmeticException.class})
        static int doIIFast(int left, int right, PNone none) {
            int result = 1;
            int exponent = right;
            int base = left;
            while (exponent != 0) {
                if ((exponent & 1) != 0) {
                    result = Math.multiplyExact(result, base);
                }
                if ((exponent >>= 1) == 0) continue;
                base = Math.multiplyExact(base, base);
            }
            return result;
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={ArithmeticException.class})
        @HostCompilerDirectives.InliningCutoff
        static long doLLFast(long left, long right, PNone none) {
            long result = 1L;
            long exponent = right;
            long base = left;
            while (exponent != 0L) {
                if ((exponent & 1L) != 0L) {
                    result = Math.multiplyExact(result, base);
                }
                if ((exponent >>= 1) == 0L) continue;
                base = Math.multiplyExact(base, base);
            }
            return result;
        }

        @Specialization(guards={"right >= 0"}, replaces={"doLLFast"})
        @HostCompilerDirectives.InliningCutoff
        PInt doLLPos(long left, long right, PNone none, @Bind PythonLanguage language) {
            return PFactory.createInt(language, this.op(PInt.longToBigInteger(left), right));
        }

        @Specialization(guards={"right < 0"})
        @HostCompilerDirectives.InliningCutoff
        double doLLNeg(long left, long right, PNone none, @Bind Node inliningTarget, @Cached.Shared(value="leftIsZero") @Cached InlinedConditionProfile leftIsZero, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (leftIsZero.profile(inliningTarget, left == 0L)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return Math.pow(left, right);
        }

        @Specialization(rewriteOn={OverflowException.class, ArithmeticException.class})
        @HostCompilerDirectives.InliningCutoff
        Object doLPNarrow(long left, PInt right, PNone none, @Bind Node inliningTarget, @Cached.Shared(value="leftIsZero") @Cached InlinedConditionProfile leftIsZero, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            long lright = right.longValueExact();
            if (lright >= 0L) {
                return PowNode.doLLFast(left, lright, none);
            }
            return this.doLLNeg(left, lright, none, inliningTarget, leftIsZero, raiseNode);
        }

        @Specialization(replaces={"doLPNarrow"})
        @HostCompilerDirectives.InliningCutoff
        Object doLP(long left, PInt right, PNone none) {
            Object result = this.op(PInt.longToBigInteger(left), right.getValue());
            if (result instanceof BigInteger) {
                return PFactory.createInt(PythonLanguage.get(this), (BigInteger)result);
            }
            return result;
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={OverflowException.class})
        @HostCompilerDirectives.InliningCutoff
        long doPLNarrow(PInt left, long right, PNone none) throws OverflowException {
            return PInt.longValueExact(this.op(left.getValue(), right));
        }

        @Specialization(guards={"right >= 0"}, replaces={"doPLNarrow"})
        @HostCompilerDirectives.InliningCutoff
        PInt doPLPos(PInt left, long right, PNone none, @Bind PythonLanguage language) {
            return PFactory.createInt(language, this.op(left.getValue(), right));
        }

        @Specialization(guards={"right < 0"})
        @HostCompilerDirectives.InliningCutoff
        double doPLNeg(PInt left, long right, PNone none, @Bind Node inliningTarget, @Cached.Shared(value="leftIsZero") @Cached InlinedConditionProfile leftIsZero, @Cached.Shared @Cached PRaiseNode raiseNode) {
            double leftDouble = PInt.doubleValueWithOverflow(this, left.getValue());
            if (leftIsZero.profile(inliningTarget, leftDouble == 0.0)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return Math.pow(leftDouble, right);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        Object doPP(PInt left, PInt right, PNone none) {
            Object result = this.op(left.getValue(), right.getValue());
            if (result instanceof BigInteger) {
                return PFactory.createInt(PythonLanguage.get(this), (BigInteger)result);
            }
            return result;
        }

        @Specialization(guards={"right >= 0", "mod > 0"})
        @HostCompilerDirectives.InliningCutoff
        static long doLLPosLPos(long left, long right, long mod) {
            try {
                return PInt.longValueExact(PowNode.op(left, right, mod));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }

        @Specialization(guards={"right >= 0"}, replaces={"doLLPosLPos"})
        @HostCompilerDirectives.InliningCutoff
        static long doLLPosLGeneric(long left, long right, long mod, @Bind Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile modNegativeProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (mod == 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.POW_THIRD_ARG_CANNOT_BE_ZERO);
            }
            try {
                if (modNegativeProfile.profile(inliningTarget, mod < 0L)) {
                    return PInt.longValueExact(PowNode.opNeg(left, right, mod));
                }
                return PInt.longValueExact(PowNode.op(left, right, mod));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }

        @Specialization(replaces={"doPP"})
        @HostCompilerDirectives.InliningCutoff
        Object powModulo(Object x, Object y, Object z) {
            Object result;
            if (!MathGuards.isInteger(x) || !MathGuards.isInteger(y)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (z instanceof PNone) {
                result = this.objectOp(x, y);
            } else if (MathGuards.isInteger(z)) {
                result = this.objectOp(x, y, z);
            } else {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (result instanceof BigInteger) {
                return PFactory.createInt(PythonLanguage.get(this), (BigInteger)result);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private Object objectOp(Object left, Object right) {
            BigInteger bigLeft = PowNode.integerToBigInteger(left);
            BigInteger bigRight = PowNode.integerToBigInteger(right);
            return this.op(bigLeft, bigRight);
        }

        @CompilerDirectives.TruffleBoundary
        private Object objectOp(Object left, Object right, Object mod) {
            BigInteger bigLeft = PowNode.integerToBigInteger(left);
            BigInteger bigRight = PowNode.integerToBigInteger(right);
            BigInteger bigMod = PowNode.integerToBigInteger(mod);
            if (bigMod.signum() == 0) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.POW_THIRD_ARG_CANNOT_BE_ZERO);
            }
            BigInteger bigModPos = bigMod.signum() < 0 ? bigMod.abs() : bigMod;
            try {
                BigInteger pow = bigLeft.modPow(bigRight, bigModPos);
                if (bigModPos != bigMod && !BigInteger.ZERO.equals(pow)) {
                    return pow.subtract(bigModPos);
                }
                return pow;
            }
            catch (ArithmeticException e) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.POW_BASE_NOT_INVERTIBLE);
            }
        }

        private static BigInteger integerToBigInteger(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (value instanceof Integer) {
                return BigInteger.valueOf(((Integer)value).intValue());
            }
            if (value instanceof Long) {
                return BigInteger.valueOf((Long)value);
            }
            if (value instanceof PInt) {
                return ((PInt)value).getValue();
            }
            throw CompilerDirectives.shouldNotReachHere((String)"never reached");
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(long left, long right, long mod) {
            assert (mod > 0L);
            assert (right >= 0L);
            return BigInteger.valueOf(left).modPow(BigInteger.valueOf(right), BigInteger.valueOf(mod));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger opNeg(long left, long right, long mod) {
            assert (mod < 0L);
            BigInteger modPos = BigInteger.valueOf(-mod);
            BigInteger pow = right == 0L ? BigInteger.ONE : BigInteger.valueOf(left).modPow(BigInteger.valueOf(right), modPos);
            if (!BigInteger.ZERO.equals(pow)) {
                return pow.subtract(modPos);
            }
            return pow;
        }

        @CompilerDirectives.TruffleBoundary
        private Object op(BigInteger left, BigInteger right) {
            if (right.signum() >= 0) {
                try {
                    return this.op(left, right.longValueExact());
                }
                catch (ArithmeticException e) {
                    return this.op(left, Long.MAX_VALUE);
                }
            }
            double leftDouble = PInt.doubleValueWithOverflow(this, left);
            double rightDouble = PInt.doubleValueWithOverflow(this, right);
            if (leftDouble == 0.0) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return Math.pow(leftDouble, rightDouble);
        }

        @CompilerDirectives.TruffleBoundary
        private BigInteger op(BigInteger a, long b) {
            assert (b >= 0L);
            try {
                int value = a.intValueExact();
                if (value == 0) {
                    if (b == 0L) {
                        return BigInteger.ONE;
                    }
                    return BigInteger.ZERO;
                }
                if (value == 1) {
                    return BigInteger.ONE;
                }
                if (value == -1) {
                    return (b & 1L) != 0L ? PInt.longToBigInteger(-1L) : BigInteger.ONE;
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (b != (long)((int)b)) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ArithmeticError, ErrorMessages.EXPONENT_TOO_LARGE);
            }
            return a.pow((int)b);
        }

        @NeverDefault
        public static PowNode create() {
            return IntBuiltinsFactory.PowNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_multiply, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class MulNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int x, int y) throws ArithmeticException {
            return Math.multiplyExact(x, y);
        }

        @Specialization(replaces={"doII"})
        static long doIIL(int x, int y) {
            return (long)x * (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long doLL(long x, long y) {
            return Math.multiplyExact(x, y);
        }

        @Specialization(replaces={"doLL"})
        static Object doLongWithOverflow(long x, long y, @Bind Node inliningTarget) {
            long ay;
            long r = x * y;
            long ax = Math.abs(x);
            if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
                return PFactory.createInt(PythonLanguage.get(inliningTarget), MulNode.mul(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
            }
            return r;
        }

        @Specialization(guards={"right == 0"})
        static int doPIntLongZero(PInt left, long right) {
            return 0;
        }

        @Specialization(guards={"left == 0"})
        static int doPIntLongZero(long left, PInt right) {
            return 0;
        }

        @Specialization(guards={"right == 1"})
        static PInt doPIntLongOne(PInt left, long right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, left.getValue());
        }

        @Specialization(guards={"left == 1"})
        PInt doPIntLongOne(long left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, right.getValue());
        }

        @Specialization(guards={"right != 0", "right != 1"})
        static PInt doPIntLong(PInt left, long right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, MulNode.mul(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"left != 0", "left != 1"})
        PInt doPIntLong(long left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, MulNode.mul(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization
        static PInt doPIntPInt(PInt left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, MulNode.mul(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger mul(BigInteger a, BigInteger b) {
            if (!BigInteger.ZERO.equals(b) && b.and(b.subtract(BigInteger.ONE)).equals(BigInteger.ZERO)) {
                return MulNode.bigIntegerShift(a, b.getLowestSetBit());
            }
            return MulNode.bigIntegerMul(a, b);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger bigIntegerMul(BigInteger a, BigInteger b) {
            return a.multiply(b);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger bigIntegerShift(BigInteger a, int n) {
            return a.shiftLeft(n);
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static MulNode create() {
            return IntBuiltinsFactory.MulNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_remainder, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    public static abstract class ModNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract int executeInt(int var1, int var2) throws UnexpectedResultException;

        public abstract Object execute(int var1, int var2);

        @Specialization
        static int doII(int left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0, raiseNode);
            return Math.floorMod(left, right);
        }

        @Specialization
        static long doLL(long left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return Math.floorMod(left, right);
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        static long doLPiAndNarrow(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PInt.longValueExact(ModNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, replaces={"doLPiAndNarrow"})
        static PInt doLPi(long left, PInt right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PFactory.createInt(language, ModNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        static long doLPiNegativeAndNarrow(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PInt.longValueExact(ModNode.opNeg(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, replaces={"doLPiNegativeAndNarrow"})
        static PInt doLPiNegative(long left, PInt right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PFactory.createInt(language, ModNode.opNeg(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={OverflowException.class})
        static long doPiLAndNarrow(PInt left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return PInt.longValueExact(ModNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right >= 0"}, replaces={"doPiLAndNarrow"})
        static PInt doPiL(PInt left, long right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return PFactory.createInt(language, ModNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right < 0"}, rewriteOn={OverflowException.class})
        static long doPiLNegAndNarrow(PInt left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return PInt.longValueExact(ModNode.opNeg(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right < 0"}, replaces={"doPiLNegAndNarrow"})
        static PInt doPiLNeg(PInt left, long right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return PFactory.createInt(language, ModNode.opNeg(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        static long doPiPiAndNarrow(PInt left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PInt.longValueExact(ModNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, replaces={"doPiPiAndNarrow"})
        static PInt doPiPi(PInt left, PInt right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PFactory.createInt(language, ModNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        static long doPiPiNegAndNarrow(PInt left, PInt right) throws OverflowException {
            return PInt.longValueExact(ModNode.opNeg(left.getValue(), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, replaces={"doPiPiNegAndNarrow"})
        static PInt doPiPiNeg(PInt left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, ModNode.opNeg(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger op(BigInteger a, BigInteger b) {
            return a.mod(b);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger opNeg(BigInteger a, BigInteger b) {
            if (a.signum() == 0) {
                return BigInteger.ZERO;
            }
            BigInteger mod = a.mod(b.negate());
            if (mod.signum() == 0) {
                return BigInteger.ZERO;
            }
            return a.mod(b.negate()).subtract(b.negate());
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static ModNode create() {
            return IntBuiltinsFactory.ModNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_divmod, isComplex=true)
    @GenerateNodeFactory
    static abstract class DivModNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        DivModNode() {
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached FloorDivNode floorDivNode, @Cached ModNode modNode) {
            Object div = floorDivNode.execute(frame, left, right);
            if (div == PNotImplemented.NOT_IMPLEMENTED) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            Object mod = modNode.execute(frame, left, right);
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), new Object[]{div, mod});
        }
    }

    @Slot(value=Slot.SlotKind.nb_floor_divide, isComplex=true)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    @GenerateNodeFactory
    public static abstract class FloorDivNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        private static final long INT_OVERFLOW_VALUE = 0x80000000L;
        private static final BigInteger LONG_OVERFLOW_VALUE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

        public abstract Object execute(int var1, int var2);

        @Specialization
        static Object doII(int left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile overflowValueProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0, raiseNode);
            if (left == Integer.MIN_VALUE && right == -1) {
                overflowValueProfile.enter(inliningTarget);
                return 0x80000000L;
            }
            return Math.floorDiv(left, right);
        }

        @Specialization
        static Object doLL(long left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile overflowValueProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            if (left == Long.MIN_VALUE && right == -1L) {
                overflowValueProfile.enter(inliningTarget);
                return PFactory.createInt(PythonLanguage.get(inliningTarget), LONG_OVERFLOW_VALUE);
            }
            return Math.floorDiv(left, right);
        }

        @Specialization
        static Object doIPi(int left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile overflowValueProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                int rightValue = right.intValueExact();
                IntBuiltins.raiseDivisionByZero(inliningTarget, rightValue == 0, raiseNode);
                if (left == Integer.MIN_VALUE && rightValue == -1) {
                    overflowValueProfile.enter(inliningTarget);
                    return 0x80000000L;
                }
                return Math.floorDiv(left, rightValue);
            }
            catch (OverflowException e) {
                return left == 0 || left < 0 == right.isNegative() ? 0 : -1;
            }
        }

        @Specialization
        static Object doLPi(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile overflowValueProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                long rightValue = right.longValueExact();
                IntBuiltins.raiseDivisionByZero(inliningTarget, rightValue == 0L, raiseNode);
                if (left == Long.MIN_VALUE && rightValue == -1L) {
                    overflowValueProfile.enter(inliningTarget);
                    return PFactory.createInt(PythonLanguage.get(inliningTarget), LONG_OVERFLOW_VALUE);
                }
                return Math.floorDiv(left, rightValue);
            }
            catch (OverflowException e) {
                return left == 0L || left < 0L == right.isNegative() ? 0 : -1;
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPiIAndNarrow(PInt left, int right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0, raiseNode);
            return PInt.longValueExact(FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPiIAndNarrow"})
        static PInt doPiI(PInt left, int right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0, raiseNode);
            return PFactory.createInt(language, FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPiLAndNarrow(PInt left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return PInt.longValueExact(FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPiLAndNarrow"})
        static PInt doPiL(PInt left, long right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right == 0L, raiseNode);
            return PFactory.createInt(language, FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPiPiAndNarrow(PInt left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) throws OverflowException {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PInt.longValueExact(FloorDivNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(replaces={"doPiPiAndNarrow"})
        static PInt doPiPi(PInt left, PInt right, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            IntBuiltins.raiseDivisionByZero(inliningTarget, right.isZero(), raiseNode);
            return PFactory.createInt(language, FloorDivNode.op(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger op(BigInteger left, BigInteger right) {
            BigInteger r = left.divide(right);
            if (left.xor(right).signum() < 0 && r.multiply(right).compareTo(left) != 0) {
                r = r.subtract(BigInteger.ONE);
            }
            return r;
        }

        @Fallback
        static PNotImplemented doGeneric(Object right, Object left) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static FloorDivNode create() {
            return IntBuiltinsFactory.FloorDivNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_true_divide, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class TrueDivNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization
        static double divII(int x, int y, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return TrueDivNode.divDD(x, y, inliningTarget, raiseNode);
        }

        @Specialization(guards={"fitsIntoDouble(x)", "fitsIntoDouble(y)"})
        static double divLL(long x, long y, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return TrueDivNode.divDD(x, y, inliningTarget, raiseNode);
        }

        @Specialization(guards={"!fitsIntoDouble(x) || !fitsIntoDouble(y)"})
        static double divLLLarge(long x, long y, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (y == 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(inliningTarget, PInt.longToBigInteger(x), PInt.longToBigInteger(y));
        }

        static double divDD(double x, double y, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (y == 0.0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return x / y;
        }

        @Specialization
        static double doPI(long left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (right.isZero()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(inliningTarget, PInt.longToBigInteger(left), right.getValue());
        }

        @Specialization
        static double doPL(PInt left, long right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (right == 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(inliningTarget, left.getValue(), PInt.longToBigInteger(right));
        }

        @Specialization
        static double doPP(PInt left, PInt right, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (right.isZero()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(inliningTarget, left.getValue(), right.getValue());
        }

        @CompilerDirectives.TruffleBoundary
        private static double op(Node raisingNode, BigInteger a, BigInteger b) {
            int precisionOfDouble = 18;
            if (TrueDivNode.fitsIntoDouble(a) && TrueDivNode.fitsIntoDouble(b)) {
                return a.doubleValue() / b.doubleValue();
            }
            BigDecimal aDecimal = new BigDecimal(a);
            BigDecimal bDecimal = new BigDecimal(b);
            int aPrec = aDecimal.precision();
            int bPrec = bDecimal.precision();
            BigDecimal result = aDecimal.divide(bDecimal, bPrec - aPrec + 18, RoundingMode.HALF_EVEN);
            double d = result.doubleValue();
            if (Double.isInfinite(d)) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.OverflowError, ErrorMessages.INTEGER_DIVISION_RESULT_TOO_LARGE);
            }
            return d;
        }

        public static boolean fitsIntoDouble(long x) {
            return x < 0x10000000000000L && x > -4503599627370496L;
        }

        private static boolean fitsIntoDouble(BigInteger x) {
            return x.bitLength() < 53;
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static TrueDivNode create() {
            return IntBuiltinsFactory.TrueDivNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_subtract, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class SubNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int x, int y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization(replaces={"doII"})
        static long doIIOvf(int x, int y) {
            return (long)x - (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long doLL(long x, long y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization(replaces={"doLL"})
        static Object doLongWithOverflow(long x, long y, @Bind Node inliningTarget) {
            long r = x - y;
            if (((x ^ y) & (x ^ r)) < 0L) {
                return PFactory.createInt(PythonLanguage.get(inliningTarget), SubNode.sub(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
            }
            return r;
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPIntLongAndNarrow(PInt left, long right) throws OverflowException {
            return PInt.longValueExact(SubNode.sub(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPIntLongAndNarrow"})
        static PInt doPIntLong(PInt left, long right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, SubNode.sub(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doLongPIntAndNarrow(long left, PInt right) throws OverflowException {
            return PInt.longValueExact(SubNode.sub(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(replaces={"doLongPIntAndNarrow"})
        static PInt doLongPInt(long left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, SubNode.sub(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPIntPIntAndNarrow(PInt left, PInt right) throws OverflowException {
            return PInt.longValueExact(SubNode.sub(left.getValue(), right.getValue()));
        }

        @Specialization(replaces={"doPIntPIntAndNarrow"})
        static PInt doPIntPInt(PInt left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, SubNode.sub(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger sub(BigInteger left, BigInteger right) {
            return left.subtract(right);
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static SubNode create() {
            return IntBuiltinsFactory.SubNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.nb_add, isComplex=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonIntegerTypes.class)
    public static abstract class AddNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int left, int right) {
            return Math.addExact(left, right);
        }

        @Specialization(replaces={"doII"}, rewriteOn={ArithmeticException.class})
        static long doLL(long left, long right) {
            return Math.addExact(left, right);
        }

        @Specialization(replaces={"doLL"})
        static Object doLLOvf(long x, long y, @Bind PythonLanguage language) {
            long r = x + y;
            if (((x ^ r) & (y ^ r)) < 0L) {
                return PFactory.createInt(language, AddNode.add(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
            }
            return r;
        }

        @Specialization(rewriteOn={OverflowException.class})
        static Object doPLNarrow(PInt left, long right) throws OverflowException {
            return PInt.longValueExact(AddNode.add(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPLNarrow"})
        static Object doPL(PInt left, long right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, AddNode.add(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static Object doLPNarrow(long left, PInt right) throws OverflowException {
            return PInt.longValueExact(AddNode.add(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(replaces={"doLPNarrow"})
        static Object doLP(long left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, AddNode.add(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static Object doPPNarrow(PInt left, PInt right) throws OverflowException {
            return PInt.longValueExact(AddNode.add(left.getValue(), right.getValue()));
        }

        @Specialization(replaces={"doPPNarrow"})
        static Object doPP(PInt left, PInt right, @Bind PythonLanguage language) {
            return PFactory.createInt(language, AddNode.add(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger add(BigInteger left, BigInteger right) {
            return left.add(right);
        }

        static boolean isNotImplemented(Object x) {
            return !(x instanceof Long) && !(x instanceof Integer) && !(x instanceof Boolean) && !(x instanceof PInt);
        }

        @Specialization(guards={"isNotImplemented(left) || isNotImplemented(right)"})
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static AddNode create() {
            return IntBuiltinsFactory.AddNodeFactory.create();
        }
    }

    @Builtin(name="__round__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class RoundNode
    extends PythonBinaryBuiltinNode {
        RoundNode() {
        }

        @Specialization
        static int roundIntNone(int arg, PNone n) {
            return arg;
        }

        @Specialization
        static long roundLongNone(long arg, PNone n) {
            return arg;
        }

        @Specialization
        static PInt roundPIntNone(PInt arg, PNone n, @Bind Node inliningTarget, @Bind PythonLanguage language) {
            return PFactory.createInt(language, arg.getValue());
        }

        @Specialization
        static Object roundLongInt(long arg, int n, @Bind Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow, @Cached.Shared(value="longOvf") @Cached InlinedBranchProfile longOverflow) {
            if (n >= 0) {
                return arg;
            }
            return RoundNode.makeInt(inliningTarget, RoundNode.op(arg, n), intOverflow, longOverflow);
        }

        @Specialization
        static Object roundPIntInt(PInt arg, int n, @Bind Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow, @Cached.Shared(value="longOvf") @Cached InlinedBranchProfile longOverflow) {
            if (n >= 0) {
                return arg;
            }
            return RoundNode.makeInt(inliningTarget, RoundNode.op(arg.getValue(), n), intOverflow, longOverflow);
        }

        @Specialization
        static Object roundLongLong(long arg, long n, @Bind Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow, @Cached.Shared(value="longOvf") @Cached InlinedBranchProfile longOverflow) {
            if (n >= 0L) {
                return arg;
            }
            if (n < Integer.MIN_VALUE) {
                return 0;
            }
            return RoundNode.makeInt(inliningTarget, RoundNode.op(arg, (int)n), intOverflow, longOverflow);
        }

        @Specialization
        static Object roundPIntLong(PInt arg, long n, @Bind Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow, @Cached.Shared(value="longOvf") @Cached InlinedBranchProfile longOverflow) {
            if (n >= 0L) {
                return arg;
            }
            if (n < Integer.MIN_VALUE) {
                return 0;
            }
            return RoundNode.makeInt(inliningTarget, RoundNode.op(arg.getValue(), (int)n), intOverflow, longOverflow);
        }

        @Specialization
        static Object roundPIntLong(long arg, PInt n, @Bind Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow, @Cached.Shared(value="longOvf") @Cached InlinedBranchProfile longOverflow) {
            if (n.isZeroOrPositive()) {
                return arg;
            }
            try {
                return RoundNode.makeInt(inliningTarget, RoundNode.op(arg, n.intValueExact()), intOverflow, longOverflow);
            }
            catch (OverflowException e) {
                return 0;
            }
        }

        @Specialization
        static Object roundPIntPInt(PInt arg, PInt n, @Bind Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow, @Cached.Shared(value="longOvf") @Cached InlinedBranchProfile longOverflow) {
            if (n.isZeroOrPositive()) {
                return arg;
            }
            try {
                return RoundNode.makeInt(inliningTarget, RoundNode.op(arg.getValue(), n.intValueExact()), intOverflow, longOverflow);
            }
            catch (OverflowException e) {
                return 0;
            }
        }

        @Specialization(guards={"!isInteger(n)"})
        static Object roundPIntPInt(Object arg, Object n, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, n);
        }

        private static Object makeInt(Node inliningTarget, BigDecimal d, InlinedBranchProfile intOverflow, InlinedBranchProfile longOverflow) {
            try {
                return RoundNode.intValueExact(d);
            }
            catch (OverflowException e) {
                intOverflow.enter(inliningTarget);
                try {
                    return RoundNode.longValueExact(d);
                }
                catch (OverflowException e2) {
                    longOverflow.enter(inliningTarget);
                    try {
                        return PFactory.createInt(PythonLanguage.get(inliningTarget), RoundNode.toBigIntegerExact(d));
                    }
                    catch (OverflowException e3) {
                        throw CompilerDirectives.shouldNotReachHere((String)"non-integer produced after rounding an integer", (Throwable)e3);
                    }
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger toBigIntegerExact(BigDecimal d) throws OverflowException {
            try {
                return d.toBigIntegerExact();
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static int intValueExact(BigDecimal d) throws OverflowException {
            try {
                return d.intValueExact();
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static long longValueExact(BigDecimal d) throws OverflowException {
            try {
                return d.longValueExact();
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigDecimal op(long arg, int n) {
            try {
                return new BigDecimal(arg).setScale(n, RoundingMode.HALF_EVEN);
            }
            catch (ArithmeticException e) {
                return BigDecimal.ZERO;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigDecimal op(BigInteger arg, int n) {
            try {
                return new BigDecimal(arg).setScale(n, RoundingMode.HALF_EVEN);
            }
            catch (ArithmeticException e) {
                return BigDecimal.ZERO;
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="int", minNumOfPositionalArgs=1, parameterNames={"cls", "x", "base"}, numOfPositionalOnlyArgs=2)
    @GenerateNodeFactory
    public static abstract class IntNewNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object doGeneric(VirtualFrame frame, Object cls, Object x, Object baseObj, @Bind Node inliningTarget, @Cached IntNodeInnerNode innerNode, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached CreateIntSubclassNode createIntSubclassNode) {
            Object result = innerNode.execute(frame, inliningTarget, x, baseObj);
            if (isPrimitiveIntProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PInt)) {
                return result;
            }
            return createIntSubclassNode.execute(inliningTarget, cls, result);
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={PGuards.class})
        static abstract class IntNodeInnerNode
        extends Node {
            IntNodeInnerNode() {
            }

            public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

            @Specialization(guards={"isNoValue(baseObj)"})
            static Object doNoBase(VirtualFrame frame, Node inliningTarget, Object x, Object baseObj, @Cached @Cached.Exclusive InlinedBranchProfile noX, @Cached PyNumberLongNode pyNumberLongNode) {
                if (x == PNone.NO_VALUE) {
                    noX.enter(inliningTarget);
                    return 0;
                }
                return pyNumberLongNode.execute((Frame)frame, inliningTarget, x);
            }

            @HostCompilerDirectives.InliningCutoff
            @Fallback
            static Object doWithBase(VirtualFrame frame, Node inliningTarget, Object x, Object baseObj, @Cached @Cached.Exclusive InlinedBranchProfile missingArgument, @Cached @Cached.Exclusive InlinedBranchProfile wrongBase, @Cached @Cached.Exclusive InlinedBranchProfile cannotConvert, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PyLongFromUnicodeObject longFromUnicode, @Cached BytesNodes.BytesLikeCheck bytesLikeCheck, @Cached PyNumberLongNode.LongFromBufferNode fromBufferNode, @Cached PRaiseNode raiseNode) {
                if (x == PNone.NO_VALUE) {
                    missingArgument.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INT_MISSING_STRING_ARGUMENT);
                }
                int base = asSizeNode.executeLossy((Frame)frame, inliningTarget, baseObj);
                if (base != 0 && base < 2 || base > 36) {
                    wrongBase.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INT_BASE_MUST_BE_2_AND_36_OR_0);
                }
                if (unicodeCheckNode.execute(inliningTarget, x)) {
                    return longFromUnicode.execute(inliningTarget, x, base);
                }
                if (bytesLikeCheck.execute(inliningTarget, x)) {
                    return fromBufferNode.execute(frame, x, base);
                }
                cannotConvert.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INT_CANT_CONVERT_STRING_WITH_EXPL_BASE);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class CreateIntSubclassNode
        extends Node {
            CreateIntSubclassNode() {
            }

            public abstract Object execute(Node var1, Object var2, Object var3);

            @Specialization
            static Object doSubclass(Object cls, int value, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                return PFactory.createInt(language, cls, getInstanceShape.execute(cls), value);
            }

            @Specialization
            static Object doSubclass(Object cls, long value, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                return PFactory.createInt(language, cls, getInstanceShape.execute(cls), value);
            }

            @Specialization
            static Object doSubclass(Object cls, boolean value, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                return PFactory.createInt(language, cls, getInstanceShape.execute(cls), PInt.intValue(value));
            }

            @Specialization
            static Object doSubclass(Object cls, PInt value, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                return PFactory.createInt(language, cls, getInstanceShape.execute(cls), value.getValue());
            }
        }
    }
}

