/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class DateAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 7;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    DateAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.DATE, stmt, 7, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DateAccessor.class, $$$methodRef$$$4, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 12, 12, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DateAccessor.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DateAccessor.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DateAccessor.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    DateAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.DATE, stmt, 7, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DateAccessor.class, $$$methodRef$$$5, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 12, 12, form, false);
            this.initForDescribe(12, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DateAccessor.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DateAccessor.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DateAccessor.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DateAccessor.class, $$$methodRef$$$0, this, n2);
            }
            String result = null;
            if (this.isUseLess || this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DateAccessor.class, $$$methodRef$$$0, this, string);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DateAccessor.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            if (this.externalType == 0) {
                result = this.statement.connection.mapDateToTimestamp ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.getTimestamp((int)currentRow)) : this.getDate((int)currentRow).toString();
            } else {
                this.getBytesInternal((int)currentRow, this.tmpBytes);
                int year = this.oracleYear(this.tmpBytes);
                int hour = 0;
                hour = this.tmpBytes[4] - 1;
                result = this.toText(year, this.tmpBytes[2], this.tmpBytes[3], hour, this.tmpBytes[5] - 1, this.tmpBytes[6] - 1, -1, hour < 12, null);
            }
            String string = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DateAccessor.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DateAccessor.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DateAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                Object var3_3 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, var3_3);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, null);
                }
                return null;
            }
            if (this.externalType == 0) {
                if (this.statement.connection.mapDateToTimestamp) {
                    Timestamp timestamp = this.getTimestamp((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, timestamp);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return timestamp;
                }
                Date date = this.getDate((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, date);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, null);
                }
                return date;
            }
            switch (this.externalType) {
                case 91: {
                    Date date = this.getDate((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, date);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return date;
                }
                case 92: {
                    Time time = this.getTime((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, time);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return time;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, timestamp);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return timestamp;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DateAccessor.class, $$$methodRef$$$2, this, n2);
            }
            DATE dATE = this.getDATE((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DateAccessor.class, $$$methodRef$$$2, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DateAccessor.class, $$$methodRef$$$2, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DateAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DateAccessor.class, $$$methodRef$$$3, this, n2, map);
            }
            Object object = this.getObject((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DateAccessor.class, $$$methodRef$$$3, this, object);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DateAccessor.class, $$$methodRef$$$3, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DateAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = DateAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DateAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DateAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DateAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DateAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DateAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

