/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashJNI;

final class StreamingXXHash32JNI
extends StreamingXXHash32 {
    private long state;

    StreamingXXHash32JNI(int n2) {
        super(n2);
        this.state = XXHashJNI.XXH32_init(n2);
    }

    private void checkState() {
        if (this.state == 0L) {
            throw new AssertionError((Object)"Already finalized");
        }
    }

    @Override
    public void reset() {
        this.checkState();
        XXHashJNI.XXH32_free(this.state);
        this.state = XXHashJNI.XXH32_init(this.seed);
    }

    @Override
    public int getValue() {
        this.checkState();
        return XXHashJNI.XXH32_digest(this.state);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.checkState();
        XXHashJNI.XXH32_update(this.state, byArray, n2, n3);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        XXHashJNI.XXH32_free(this.state);
        this.state = 0L;
    }

    static class Factory
    implements StreamingXXHash32.Factory {
        public static final StreamingXXHash32.Factory INSTANCE = new Factory();

        Factory() {
        }

        @Override
        public StreamingXXHash32 newStreamingHash(int n2) {
            return new StreamingXXHash32JNI(n2);
        }
    }
}

