/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.dbcrypt;

public final class DbCryptData {
    public static final DbCryptData EMPTY_DATA = new DbCryptData(null, 0);
    private final byte[] pluginData;
    private final int replySize;

    public DbCryptData(byte[] pluginData, int replySize) {
        if (pluginData != null && pluginData.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Length of plugin data exceeds maximum length of 32767 bytes, was: " + pluginData.length);
        }
        this.pluginData = pluginData;
        this.replySize = replySize;
    }

    public byte[] getPluginData() {
        return this.pluginData;
    }

    public int getReplySize() {
        return this.replySize;
    }

    public static DbCryptData createReply(byte[] pluginData) {
        if (pluginData == null) {
            return EMPTY_DATA;
        }
        return new DbCryptData(pluginData, 0);
    }
}

