/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.native_memory.NativeBuffer;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import sun.misc.Unsafe;

public abstract class NativePrimitiveSequenceStorage
extends SequenceStorage {
    protected static final Unsafe unsafe = PythonUtils.initUnsafe();
    private final NativeBuffer valueBuffer;
    private long valueBufferAddr;
    protected final long itemSize;

    public NativePrimitiveSequenceStorage(NativeBuffer valueBuffer, int length, long itemSize) {
        this.valueBuffer = valueBuffer;
        this.valueBufferAddr = valueBuffer.getMemoryAddress();
        this.length = length;
        this.itemSize = itemSize;
        this.capacity = this.calculateCapacity(valueBuffer.getCapacityInBytes());
    }

    public final long getValueBufferAddr() {
        assert (this.valueBuffer.getMemoryAddress() == this.valueBufferAddr);
        return this.valueBufferAddr;
    }

    public final void reallocate(int capacity) {
        long newCapacityInBytes = this.itemSize * (long)capacity;
        this.valueBuffer.reallocate(newCapacityInBytes);
        this.valueBufferAddr = this.valueBuffer.getMemoryAddress();
    }

    public long getItemSize() {
        return this.itemSize;
    }

    public NativeBuffer getValueBuffer() {
        return this.valueBuffer;
    }

    private int calculateCapacity(long capacityInBytes) {
        return Math.toIntExact(capacityInBytes / this.itemSize);
    }
}

