/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode_dsl;

import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.bytecode.serialization.BytecodeSerializer;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BytecodeDSLCodeUnit
extends CodeUnit {
    private volatile byte[] serialized;
    private final BytecodeRootNodes<PBytecodeDSLRootNode> nodes;
    public final int classcellIndex;
    public final int selfIndex;

    public BytecodeDSLCodeUnit(TruffleString name, TruffleString qualname, int argCount, int kwOnlyArgCount, int positionalOnlyArgCount, int flags, TruffleString[] names, TruffleString[] varnames, TruffleString[] cellvars, TruffleString[] freevars, int[] cell2arg, Object[] constants, int startLine, int startColumn, int endLine, int endColumn, int classcellIndex, int selfIndex, byte[] serialized, BytecodeRootNodes<PBytecodeDSLRootNode> nodes) {
        super(name, qualname, argCount, kwOnlyArgCount, positionalOnlyArgCount, flags, names, varnames, cellvars, freevars, cell2arg, constants, startLine, startColumn, endLine, endColumn);
        assert (serialized == null ^ nodes == null);
        this.serialized = serialized;
        this.nodes = nodes;
        this.classcellIndex = classcellIndex;
        this.selfIndex = selfIndex;
    }

    @CompilerDirectives.TruffleBoundary
    public PBytecodeDSLRootNode createRootNode(PythonContext context, Source source) {
        byte[] toDeserialize = this.getSerialized(context);
        BytecodeRootNodes<PBytecodeDSLRootNode> deserialized = MarshalModuleBuiltins.deserializeBytecodeNodes(context, source, toDeserialize);
        assert (deserialized.count() == 1);
        PBytecodeDSLRootNode result = (PBytecodeDSLRootNode)deserialized.getNode(0);
        result.setMetadata(this, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSerialized(PythonContext context) {
        CompilerAsserts.neverPartOfCompilation();
        byte[] result = this.serialized;
        if (result == null) {
            BytecodeDSLCodeUnit bytecodeDSLCodeUnit = this;
            synchronized (bytecodeDSLCodeUnit) {
                result = this.serialized;
                if (result == null) {
                    result = this.serialized = this.computeSerialized(context);
                }
            }
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] computeSerialized(PythonContext context) {
        try {
            MarshalModuleBuiltins.PBytecodeDSLSerializer serializer = new MarshalModuleBuiltins.PBytecodeDSLSerializer(context);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.nodes.serialize((DataOutput)new DataOutputStream(bytes), (BytecodeSerializer)serializer);
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public TruffleString getDocstring() {
        Object object;
        if (this.constants.length > 0 && (object = this.constants[0]) instanceof TruffleString) {
            TruffleString docstring = (TruffleString)object;
            return docstring;
        }
        return null;
    }

    @Override
    protected void dumpBytecode(StringBuilder sb, boolean optimized) {
        for (int i = 0; i < this.nodes.count(); ++i) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(((PBytecodeDSLRootNode)this.nodes.getNode(i)).dump());
            sb.append('\n');
        }
    }
}

