/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.bytecode.ForIterONodeGen;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;

@GenerateUncached
@GenerateInline(value=false)
public abstract class ForIterONode
extends PNodeWithContext {
    public abstract boolean execute(Frame var1, Object var2, int var3);

    @Specialization
    boolean doIntRange(VirtualFrame frame, PIntRangeIterator iterator, int stackTop, @Bind Node inliningTarget, @Cached InlinedCountingConditionProfile conditionProfile) {
        if (conditionProfile.profile(inliningTarget, iterator.hasNextInt())) {
            frame.setObject(stackTop, (Object)iterator.nextInt());
            return true;
        }
        iterator.setExhausted();
        return false;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static boolean doGeneric(VirtualFrame frame, Object iterator, int stackTop, @Bind Node inliningTarget, @Cached PyIterNextNode nextNode) {
        try {
            Object res = nextNode.execute((Frame)frame, inliningTarget, iterator);
            frame.setObject(stackTop, res);
            return true;
        }
        catch (IteratorExhausted e) {
            return false;
        }
    }

    public static ForIterONode create() {
        return ForIterONodeGen.create();
    }

    public static ForIterONode getUncached() {
        return ForIterONodeGen.getUncached();
    }
}

