/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodec;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecState;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteEncodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibytecodecModuleBuiltins;
import com.oracle.graal.python.builtins.modules.codecs.CodecsRegistry;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.UnicodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.CharBuffer;

public class MultibyteCodecUtil {
    protected static final char Py_UNICODE_REPLACEMENT_CHARACTER = '\ufffd';
    protected static final int MULTIBYTECODECSTATE = 8;
    static final int MBENC_RESET = 2;

    @CompilerDirectives.TruffleBoundary
    protected static MultibyteCodec findCodec(MultibyteCodec[] list, TruffleString enc, TruffleString.EqualNode isEqual) {
        for (MultibyteCodec codec : list) {
            if (codec == null || !isEqual.execute((AbstractTruffleString)codec.encoding, (AbstractTruffleString)enc, PythonUtils.TS_ENCODING)) continue;
            return codec;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    protected static CharBuffer writerInit(int len) {
        return CharBuffer.allocate(len);
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString internalErrorCallback(TruffleString errors, TruffleString.EqualNode isEqual) {
        if (errors == null || isEqual.execute((AbstractTruffleString)errors, (AbstractTruffleString)MultibytecodecModuleBuiltins.ERROR_STRICT, PythonUtils.TS_ENCODING)) {
            return MultibytecodecModuleBuiltins.ERROR_STRICT;
        }
        if (isEqual.execute((AbstractTruffleString)errors, (AbstractTruffleString)MultibytecodecModuleBuiltins.ERROR_IGNORE, PythonUtils.TS_ENCODING)) {
            return MultibytecodecModuleBuiltins.ERROR_IGNORE;
        }
        if (isEqual.execute((AbstractTruffleString)errors, (AbstractTruffleString)MultibytecodecModuleBuiltins.ERROR_REPLACE, PythonUtils.TS_ENCODING)) {
            return MultibytecodecModuleBuiltins.ERROR_REPLACE;
        }
        return errors;
    }

    protected static PBytes encodeEmptyInput(Node inliningTarget, int len, int flags) {
        if (len == 0 && (flags & 2) == 0) {
            return PFactory.createEmptyBytes(PythonLanguage.get(inliningTarget));
        }
        return null;
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class EncodeNode
    extends Node {
        EncodeNode() {
        }

        abstract PBytes execute(VirtualFrame var1, Node var2, MultibyteCodec var3, MultibyteCodecState var4, MultibyteEncodeBuffer var5, Object var6, int var7);

        @Specialization
        static PBytes encode(VirtualFrame frame, Node inliningTarget, MultibyteCodec codec, MultibyteCodecState state, MultibyteEncodeBuffer buf, Object errors, int flags, @Cached(inline=false) EncodeErrorNode encodeErrorNode, @Cached PRaiseNode raiseNode) {
            int r;
            if (buf.getInlen() > 0x3FFFFFF7) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.MemoryError);
            }
            while (!(buf.isFull() || (r = codec.encode(state, buf, flags)) == 0 || r == -2 && (flags & 1) == 0)) {
                encodeErrorNode.execute(frame, codec, state, buf, errors, r);
                if (r != -2) continue;
                break;
            }
            if (codec.canEncreset() && (flags & 2) != 0) {
                while ((r = codec.encreset(state, buf)) != 0) {
                    encodeErrorNode.execute(frame, codec, state, buf, errors, r);
                }
            }
            return buf.createPBytes();
        }
    }

    @GenerateInline(value=false)
    static abstract class DecodeErrorNode
    extends Node {
        DecodeErrorNode() {
        }

        abstract void execute(VirtualFrame var1, MultibyteCodec var2, MultibyteDecodeBuffer var3, TruffleString var4, int var5);

        @Specialization
        static void decerror(VirtualFrame frame, MultibyteCodec codec, MultibyteDecodeBuffer buf, TruffleString errors, int e, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached BaseExceptionAttrNode attrNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PyLongCheckNode longCheckNode, @Cached PyLongAsIntNode asSizeNode, @Cached CastToJavaStringNode toString, @Cached(inline=true) CallErrorCallbackNode callErrorCallbackNode, @Cached PRaiseNode raiseNode) {
            TruffleString reason = ErrorMessages.ILLEGAL_MULTIBYTE_SEQUENCE;
            int esize = e;
            if (e < 0) {
                switch (e) {
                    case -1: {
                        return;
                    }
                    case -2: {
                        reason = ErrorMessages.INCOMPLETE_MULTIBYTE_SEQUENCE;
                        esize = buf.remaining();
                        break;
                    }
                    case -3: {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.INTERNAL_CODEC_ERROR);
                    }
                    default: {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.UNKNOWN_RUNTIME_ERROR);
                    }
                }
            }
            if (errors == MultibytecodecModuleBuiltins.ERROR_REPLACE) {
                buf.writeChar('\ufffd');
            }
            if (errors == MultibytecodecModuleBuiltins.ERROR_IGNORE || errors == MultibytecodecModuleBuiltins.ERROR_REPLACE) {
                buf.incInpos(esize);
                return;
            }
            int start = buf.getInpos();
            int end = start + esize;
            if (buf.excobj == null) {
                buf.excobj = PFactory.createBaseException(language, PythonErrorType.UnicodeDecodeError);
                PBytes inbuf = PFactory.createBytes(language, buf.inputBuffer.array(), buf.getInpos());
                TruffleString encoding = codec.encoding;
                Object[] args = new Object[]{encoding, inbuf, buf.getInpos(), start, end, reason};
                buf.excobj.setArgs(PFactory.createTuple(language, args));
                buf.excobj.setExceptionAttributes(args);
            } else {
                attrNode.execute(buf.excobj, start, 2, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
                attrNode.execute(buf.excobj, end, 3, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
                attrNode.execute(buf.excobj, reason, 4, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            }
            if (errors == MultibytecodecModuleBuiltins.ERROR_STRICT) {
                throw raiseNode.raiseExceptionObject(inliningTarget, buf.excobj);
            }
            Object retobj = callErrorCallbackNode.execute(frame, inliningTarget, errors, buf.excobj);
            boolean isError = !(retobj instanceof PTuple);
            Object retuni = null;
            Object newposobj = null;
            if (!isError) {
                PTuple tuple = (PTuple)retobj;
                SequenceStorage storage = tuple.getSequenceStorage();
                Object[] array = getArray.execute(inliningTarget, storage);
                boolean bl = isError = storage.length() != 2;
                if (!isError) {
                    retuni = array[0];
                    newposobj = array[1];
                    isError = !unicodeCheckNode.execute(inliningTarget, retuni);
                    boolean bl2 = isError = isError || !longCheckNode.execute(inliningTarget, newposobj);
                }
            }
            if (isError) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DECODING_ERROR_HANDLER_MUST_RETURN);
            }
            buf.writeStr(toString.execute(retuni));
            int newpos = -1;
            try {
                newpos = asSizeNode.execute((Frame)frame, inliningTarget, newposobj);
                if (newpos < 0) {
                    newpos += buf.getInpos();
                }
            }
            catch (PException ee) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.IndexError, ErrorMessages.POSITION_D_FROM_ERROR_HANDLER_OUT_OF_BOUNDS, newpos);
            }
            if (newpos > buf.getInSize()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.IndexError, ErrorMessages.POSITION_D_FROM_ERROR_HANDLER_OUT_OF_BOUNDS, newpos);
            }
            buf.setInpos(newpos);
        }
    }

    @GenerateInline(value=false)
    static abstract class EncodeErrorNode
    extends Node {
        private static final CharBuffer REPLACEMENT = CharBuffer.wrap("?");

        EncodeErrorNode() {
        }

        abstract int execute(VirtualFrame var1, MultibyteCodec var2, MultibyteCodecState var3, MultibyteEncodeBuffer var4, Object var5, int var6);

        @Specialization
        static int encerror(VirtualFrame frame, MultibyteCodec codec, MultibyteCodecState state, MultibyteEncodeBuffer buf, Object errors, int e, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached BaseExceptionAttrNode attrNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached CastToTruffleStringNode toTString, @Cached PyLongCheckNode longCheckNode, @Cached PyBytesCheckNode bytesCheckNode, @Cached PyLongAsIntNode asSizeNode, @Cached(inline=true) CallErrorCallbackNode callErrorCallbackNode, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached EncodeNode encodeNode, @Cached PRaiseNode raiseNode) {
            PBytes retstr;
            TruffleString reason = ErrorMessages.ILLEGAL_MULTIBYTE_SEQUENCE;
            int esize = e;
            if (e < 0) {
                switch (e) {
                    case -1: {
                        buf.expandOutputBuffer(-1, inliningTarget);
                        return 0;
                    }
                    case -2: {
                        reason = ErrorMessages.INCOMPLETE_MULTIBYTE_SEQUENCE;
                        esize = buf.getInpos();
                        break;
                    }
                    case -3: {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.INTERNAL_CODEC_ERROR);
                    }
                    default: {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.UNKNOWN_RUNTIME_ERROR);
                    }
                }
            }
            if (errors == MultibytecodecModuleBuiltins.ERROR_REPLACE) {
                int r;
                CharBuffer origInbuf = buf.inputBuffer;
                buf.inputBuffer = REPLACEMENT;
                buf.rewindInbuf();
                while ((r = codec.encode(state, buf, 0)) == -1) {
                    buf.expandOutputBuffer(-1, inliningTarget);
                }
                buf.inputBuffer = origInbuf;
                if (r != 0) {
                    buf.expandOutputBuffer(1, inliningTarget);
                    buf.append('?');
                }
            }
            if (errors == MultibytecodecModuleBuiltins.ERROR_IGNORE || errors == MultibytecodecModuleBuiltins.ERROR_REPLACE) {
                buf.incInpos(esize);
                return 0;
            }
            int start = buf.getInpos();
            int end = start + esize;
            if (buf.excobj == null) {
                buf.excobj = PFactory.createBaseException(language, PythonErrorType.UnicodeEncodeError);
                TruffleString encoding = codec.encoding;
                Object[] args = new Object[]{encoding, buf.toTString(), start, end, reason};
                buf.excobj.setArgs(PFactory.createTuple(language, args));
                buf.excobj.setExceptionAttributes(args);
            } else {
                attrNode.execute(buf.excobj, start, 2, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
                attrNode.execute(buf.excobj, end, 3, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
                attrNode.execute(buf.excobj, reason, 4, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            }
            if (errors == MultibytecodecModuleBuiltins.ERROR_STRICT) {
                throw raiseNode.raiseExceptionObject(inliningTarget, buf.excobj);
            }
            Object retobj = callErrorCallbackNode.execute(frame, inliningTarget, errors, buf.excobj);
            boolean isError = !(retobj instanceof PTuple);
            Object tobj = null;
            Object newposobj = null;
            boolean isUnicode = false;
            if (!isError) {
                PTuple tuple = (PTuple)retobj;
                SequenceStorage storage = tuple.getSequenceStorage();
                Object[] array = getArray.execute(inliningTarget, storage);
                boolean bl = isError = storage.length() != 2;
                if (!isError) {
                    tobj = array[0];
                    newposobj = array[1];
                    isUnicode = unicodeCheckNode.execute(inliningTarget, tobj);
                    isError = !isUnicode && !bytesCheckNode.execute(inliningTarget, tobj);
                    boolean bl2 = isError = isError || !longCheckNode.execute(inliningTarget, newposobj);
                }
            }
            if (isError) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ENCODING_ERROR_HANDLER_MUST_RETURN);
            }
            if (isUnicode) {
                TruffleString str = toTString.execute(inliningTarget, tobj);
                int datalen = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
                retstr = MultibyteCodecUtil.encodeEmptyInput(inliningTarget, datalen, 1);
                if (retstr == null) {
                    MultibyteEncodeBuffer tmpbuf = new MultibyteEncodeBuffer(str);
                    retstr = encodeNode.execute(frame, inliningTarget, codec, state, tmpbuf, MultibytecodecModuleBuiltins.ERROR_STRICT, 1);
                }
            } else {
                retstr = (PBytes)tobj;
            }
            byte[] retstrbytes = toBytesNode.execute(retstr);
            int retstrsize = retstrbytes.length;
            if (retstrsize > 0) {
                buf.expandOutputBuffer(retstrsize, inliningTarget);
                buf.append(retstrbytes);
            }
            int newpos = 0;
            try {
                newpos = asSizeNode.execute((Frame)frame, inliningTarget, newposobj);
                if (newpos < 0) {
                    newpos += buf.getInlen();
                }
            }
            catch (PException exception) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.IndexError, ErrorMessages.POSITION_D_FROM_ERROR_HANDLER_OUT_OF_BOUNDS, newpos);
            }
            if (newpos < 0 || newpos > buf.getInlen()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.IndexError, ErrorMessages.POSITION_D_FROM_ERROR_HANDLER_OUT_OF_BOUNDS, newpos);
            }
            buf.setInpos(newpos);
            return 0;
        }
    }

    @GenerateInline
    @GenerateCached(alwaysInlineCached=true)
    static abstract class CallErrorCallbackNode
    extends Node {
        CallErrorCallbackNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

        @Specialization
        static Object callErrorCallback(VirtualFrame frame, Node inliningTarget, Object errors, Object exc, @Cached CastToTruffleStringNode castToStringNode, @Cached CodecsRegistry.PyCodecLookupErrorNode lookupErrorNode, @Cached(inline=false) CallNode callNode) {
            assert (PyUnicodeCheckNode.executeUncached(errors));
            TruffleString str = castToStringNode.execute(inliningTarget, errors);
            Object cb = lookupErrorNode.execute(inliningTarget, str);
            return callNode.execute((Frame)frame, cb, exc);
        }
    }
}

