/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.io;

import java.util.Arrays;
import org.graalvm.polyglot.io.ByteSequence;

final class ByteArraySequence
implements ByteSequence {
    private final byte[] buffer;
    private final int start;
    private final int length;
    private int hash;

    ByteArraySequence(byte[] buffer, int start, int length) {
        assert (buffer.length >= start + length);
        assert (start >= 0);
        assert (length >= 0);
        this.buffer = buffer;
        this.start = start;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte byteAt(int index) {
        int resolvedIndex = this.start + index;
        if (resolvedIndex >= this.start + this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.buffer[resolvedIndex];
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buffer, this.start, this.start + this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteArraySequence) {
            ByteArraySequence other = (ByteArraySequence)obj;
            if (this.buffer == other.buffer) {
                return this.start == other.start && this.length == other.length;
            }
            if (this.length != other.length) {
                return false;
            }
            int thisHash = this.hash;
            int otherHash = other.hash;
            if (thisHash != 0 && otherHash != 0 && thisHash != otherHash) {
                return false;
            }
            return Arrays.equals(this.buffer, this.start, this.start + this.length, other.buffer, other.start, other.start + other.length);
        }
        if (obj instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)obj;
            if (this.length != other.length()) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[this.start + i] == other.byteAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.length > 0) {
            h = this.start == 0 && this.length == this.buffer.length ? Arrays.hashCode(this.buffer) : ByteArraySequence.hashCode(this.buffer, this.start, this.length, 1);
            this.hash = h;
        }
        return h;
    }

    private static int hashCode(byte[] a, int fromIndex, int length, int initialValue) {
        int result = initialValue;
        int end = fromIndex + length;
        for (int i = fromIndex; i < end; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    @Override
    public ByteSequence subSequence(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(startIndex));
        }
        if (endIndex < startIndex) {
            throw new IndexOutOfBoundsException(String.valueOf((long)endIndex - (long)startIndex));
        }
        if (endIndex > this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex));
        }
        return new ByteArraySequence(this.buffer, this.start + startIndex, endIndex - startIndex);
    }
}

