/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int typeId;
    OracleType owner;
    long position;
    int uptCode;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public TDSPatch(int type, OracleType owner, long pos, int uptCode) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TDSPatch.class, $$$methodRef$$$7, null, type, owner, pos, uptCode);
            }
            this.typeId = type;
            this.owner = owner;
            this.position = pos;
            this.uptCode = uptCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TDSPatch.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TDSPatch.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TDSPatch.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    int getType() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TDSPatch.class, $$$methodRef$$$0, this, new Object[0]);
            }
            int n2 = this.typeId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TDSPatch.class, $$$methodRef$$$0, this, n2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TDSPatch.class, $$$methodRef$$$0, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TDSPatch.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    OracleNamedType getOwner() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TDSPatch.class, $$$methodRef$$$1, this, new Object[0]);
            }
            OracleNamedType oracleNamedType = (OracleNamedType)this.owner;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TDSPatch.class, $$$methodRef$$$1, this, oracleNamedType);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TDSPatch.class, $$$methodRef$$$1, this, null);
            }
            return oracleNamedType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TDSPatch.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    long getPosition() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TDSPatch.class, $$$methodRef$$$2, this, new Object[0]);
            }
            long l2 = this.position;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TDSPatch.class, $$$methodRef$$$2, this, l2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TDSPatch.class, $$$methodRef$$$2, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TDSPatch.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    byte getUptTypeCode() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TDSPatch.class, $$$methodRef$$$3, this, new Object[0]);
            }
            byte by = (byte)this.uptCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TDSPatch.class, $$$methodRef$$$3, this, by);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TDSPatch.class, $$$methodRef$$$3, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TDSPatch.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void apply(OracleType oracleType) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void typeValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TDSPatch.class, $$$methodRef$$$4, this, oracleType);
            }
            this.apply((OracleType)typeValue, -1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TDSPatch.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TDSPatch.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TDSPatch.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void apply(OracleType oracleType, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void typeValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TDSPatch.class, $$$methodRef$$$5, this, oracleType, n2);
            }
            if (this.typeId == 0) {
                OracleTypeUPT patchElem = (OracleTypeUPT)this.owner;
                patchElem.realType = (OracleTypeADT)typeValue;
                if (typeValue instanceof OracleNamedType) {
                    OracleNamedType namedType = (OracleNamedType)typeValue;
                    namedType.setParent(patchElem.getParent());
                    namedType.setOrder(patchElem.getOrder());
                }
            } else if (this.typeId == 1) {
                void opcode;
                OracleTypeCOLLECTION patchElem = (OracleTypeCOLLECTION)this.owner;
                patchElem.opcode = opcode;
                patchElem.elementType = typeValue;
                if (typeValue instanceof OracleNamedType) {
                    OracleNamedType namedType = (OracleNamedType)typeValue;
                    namedType.setParent(patchElem);
                    namedType.setOrder(1);
                }
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TDSPatch.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TDSPatch.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TDSPatch.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TDSPatch.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TDSPatch.class, $$$methodRef$$$6, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TDSPatch.class, $$$methodRef$$$6, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TDSPatch.class, $$$methodRef$$$6, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TDSPatch.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = TDSPatch.class.getDeclaredConstructor(Integer.TYPE, OracleType.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TDSPatch.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TDSPatch.class.getDeclaredMethod("apply", OracleType.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TDSPatch.class.getDeclaredMethod("apply", OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TDSPatch.class.getDeclaredMethod("getUptTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TDSPatch.class.getDeclaredMethod("getPosition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TDSPatch.class.getDeclaredMethod("getOwner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TDSPatch.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

