/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Objects;

final class TimedTaskResult
implements Serializable {
    private static final long serialVersionUID = -6572177882937039431L;
    private static final DateTimeFormatter df = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
    private final Duration duration;
    private final String taskName;
    private final Exception exception;

    TimedTaskResult(String taskName, Duration duration, Exception exception) {
        Objects.requireNonNull(taskName, "Task name not provided");
        Objects.requireNonNull(duration, "Duration not provided");
        this.taskName = taskName;
        this.duration = duration;
        this.exception = exception;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public String toString() {
        LocalTime durationLocal = LocalTime.ofNanoOfDay(this.duration.toNanos());
        return "%s - <%s>".formatted(durationLocal.format(df), this.taskName);
    }
}

