/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.impl;

import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.util.NameTransformer;

public abstract class FilteredBeanPropertyWriter {
    public static BeanPropertyWriter constructViewBased(BeanPropertyWriter base, Class<?>[] viewsToIncludeIn) {
        if (viewsToIncludeIn.length == 1) {
            return new SingleView(base, viewsToIncludeIn[0]);
        }
        return new MultiView(base, viewsToIncludeIn);
    }

    private static final class SingleView
    extends BeanPropertyWriter {
        protected final BeanPropertyWriter _delegate;
        protected final Class<?> _view;

        protected SingleView(BeanPropertyWriter delegate, Class<?> view) {
            super(delegate);
            this._delegate = delegate;
            this._view = view;
        }

        @Override
        public SingleView rename(NameTransformer transformer) {
            return new SingleView(this._delegate.rename(transformer), this._view);
        }

        @Override
        public void assignSerializer(ValueSerializer<Object> ser) {
            this._delegate.assignSerializer(ser);
        }

        @Override
        public void assignNullSerializer(ValueSerializer<Object> nullSer) {
            this._delegate.assignNullSerializer(nullSer);
        }

        @Override
        public void serializeAsProperty(Object bean, JsonGenerator gen, SerializationContext prov) throws Exception {
            Class<?> activeView = prov.getActiveView();
            if (activeView == null || this._view.isAssignableFrom(activeView)) {
                this._delegate.serializeAsProperty(bean, gen, prov);
            } else {
                this._delegate.serializeAsOmittedProperty(bean, gen, prov);
            }
        }

        @Override
        public void serializeAsElement(Object bean, JsonGenerator gen, SerializationContext prov) throws Exception {
            Class<?> activeView = prov.getActiveView();
            if (activeView == null || this._view.isAssignableFrom(activeView)) {
                this._delegate.serializeAsElement(bean, gen, prov);
            } else {
                this._delegate.serializeAsOmittedElement(bean, gen, prov);
            }
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor v, SerializationContext provider) {
            Class<?> activeView = provider.getActiveView();
            if (activeView == null || this._view.isAssignableFrom(activeView)) {
                super.depositSchemaProperty(v, provider);
            }
        }
    }

    private static final class MultiView
    extends BeanPropertyWriter {
        protected final BeanPropertyWriter _delegate;
        protected final Class<?>[] _views;

        protected MultiView(BeanPropertyWriter delegate, Class<?>[] views) {
            super(delegate);
            this._delegate = delegate;
            this._views = views;
        }

        @Override
        public MultiView rename(NameTransformer transformer) {
            return new MultiView(this._delegate.rename(transformer), this._views);
        }

        @Override
        public void assignSerializer(ValueSerializer<Object> ser) {
            this._delegate.assignSerializer(ser);
        }

        @Override
        public void assignNullSerializer(ValueSerializer<Object> nullSer) {
            this._delegate.assignNullSerializer(nullSer);
        }

        @Override
        public void serializeAsProperty(Object bean, JsonGenerator gen, SerializationContext prov) throws Exception {
            if (this._inView(prov.getActiveView())) {
                this._delegate.serializeAsProperty(bean, gen, prov);
                return;
            }
            this._delegate.serializeAsOmittedProperty(bean, gen, prov);
        }

        @Override
        public void serializeAsElement(Object bean, JsonGenerator gen, SerializationContext prov) throws Exception {
            if (this._inView(prov.getActiveView())) {
                this._delegate.serializeAsElement(bean, gen, prov);
                return;
            }
            this._delegate.serializeAsOmittedElement(bean, gen, prov);
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor v, SerializationContext provider) {
            if (this._inView(provider.getActiveView())) {
                super.depositSchemaProperty(v, provider);
            }
        }

        private final boolean _inView(Class<?> activeView) {
            if (activeView == null) {
                return true;
            }
            int len = this._views.length;
            for (int i = 0; i < len; ++i) {
                if (!this._views[i].isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }
    }
}

