/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.util.ByteConverter;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftBinaryObject;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftPoint
extends RedshiftObject
implements RedshiftBinaryObject,
Serializable,
Cloneable {
    public double x;
    public double y;

    public RedshiftPoint(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public RedshiftPoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public RedshiftPoint() {
        this.setType("point");
    }

    @Override
    public void setValue(String s) throws SQLException {
        RedshiftTokenizer t = new RedshiftTokenizer(RedshiftTokenizer.removePara(s), ',');
        try {
            this.x = Double.parseDouble(t.getToken(0));
            this.y = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), RedshiftState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public void setByteValue(byte[] b, int offset) {
        this.x = ByteConverter.float8(b, offset);
        this.y = ByteConverter.float8(b, offset + 8);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftPoint) {
            RedshiftPoint p = (RedshiftPoint)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    @Override
    public int lengthInBytes() {
        return 16;
    }

    @Override
    public void toBytes(byte[] b, int offset) {
        ByteConverter.float8(b, offset, this.x);
        ByteConverter.float8(b, offset + 8, this.y);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void move(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(int x, int y) {
        this.move((double)x, (double)y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

